package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.bindings.StringToIntegerBinding;
import ch.sahits.game.javafx.bindings.ZeroAmountBooleanBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.text.Font;

@ClassCategory(EClassCategory.JAVAFX)
public class BarrelAmount extends BarrelAmountAlwaysVisible {

	public BarrelAmount(final Font font) {
        super(font);
		IntegerProperty intAmount = new SimpleIntegerProperty();
		intAmount.bind(new StringToIntegerBinding(amountProperty()));
		visibleProperty().bind(new ZeroAmountBooleanBinding(intAmount));
	}
}
