package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.skin.OpenPatricianRadioButtonSkin;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.text.Font;

import java.net.URL;
/**
 * OpenPatrician radio button.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianRadioButton extends RadioButton {
	
	private final StringProperty selectedLabel;
	private final StringProperty unselectedLabel;
	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private final ReadOnlyObjectProperty<Font> currentFont;
	

	public OpenPatricianRadioButton() {
		this("", Font.getDefault());
	}

	public OpenPatricianRadioButton(String text, final Font font) {
		super(text);
		selectedLabel = new SimpleStringProperty(this, "selectedLabel", "yes");
		unselectedLabel = new SimpleStringProperty(this, "unselectedLabel", "no");
		this.currentFont = new ReadOnlyObjectPropertyBase<Font>() {

			@Override
			public Object getBean() {
				return this;
			}

			@Override
			public String getName() {
				return "currentFont";
			}

			@Override
			public Font get() {
				return font;
			}
		};
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	@Override
	protected Skin<?> createDefaultSkin() {
		return new OpenPatricianRadioButtonSkin(this);
	}

	public StringProperty selectedLabelProperty() {
		return selectedLabel;
	}
	public void setSelectedLabel(String label) {
		selectedLabel.set(label);
	}
	public String getSelectedLabel() {
		return selectedLabel.get();
	}
	public StringProperty unselectedLabelProperty() {
		return unselectedLabel;
	}
	public void setUnselectedLabel(String label) {
		unselectedLabel.set(label);
	}
	public String getUnselectedLabel() {
		return unselectedLabel.get();
	}
	public Font getCurrentFont() {
		return currentFont.get();
	}

}
