package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;


/**
 * Entry in the scroll pane.
 */
@ClassCategory(EClassCategory.JAVAFX)
public class ScrollPaneEntry extends Group {
    private static final String DEFAULT_LABEL_STYLE = "scrollPaneContent-label";
    private static final String ACTIVE_LABEL_STYLE = "scrollPaneContent-label-active";
    private static final String DISABLED_LABEL_STYLE = "scrollPaneContent-label-disabled";
    private Label label;

    public ScrollPaneEntry(Font font) {
        //setManaged(false);
        label = new Label();
        label.setFont(font);
        label.getStyleClass().add(DEFAULT_LABEL_STYLE);
        getChildren().add(label);
        initializeUpdateListeners();
    }

    /**
     * Cover the events which will trigger a style change.
      */
    private void initializeUpdateListeners() {
        label.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                setActive();
            }
        });
        disabledProperty().addListener(new ChangeListener<Boolean>() {
            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                if (newValue) {
                    label.getStyleClass().removeAll(DEFAULT_LABEL_STYLE, ACTIVE_LABEL_STYLE);
                    label.getStyleClass().add(DISABLED_LABEL_STYLE);
                } else {
                    label.getStyleClass().removeAll(DISABLED_LABEL_STYLE);
                    label.getStyleClass().add(DEFAULT_LABEL_STYLE);
                }
            }
        });
    }

    public StringProperty textProperty() {
        return label.textProperty();
    }

    public void setText(String s) {
        label.setText(s);
    }

    public String getText() {
        return label.getText();
    }


    /**
     * Reset the style.
     */
    public void resetStyle() {
        if (!isDisabled()) {
            label.getStyleClass().removeAll(ACTIVE_LABEL_STYLE);
            label.getStyleClass().add(DEFAULT_LABEL_STYLE);
        }
    }

	void setActive() {
		resetStyle();
		label.getStyleClass().add(ACTIVE_LABEL_STYLE);
	}

}
