package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianSmallToggableWaxButton;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

import java.io.InputStream;

/**
 * Skin for the open patrician small wax button.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
public class OpenPatricianSmallToggableWaxButtonSkin extends SkinBase<OpenPatricianSmallToggableWaxButton> {

	public OpenPatricianSmallToggableWaxButtonSkin(final OpenPatricianSmallToggableWaxButton button) {
		super(button);
		
		InputStream is = getClass().getResourceAsStream("sealingWaxFlattend.png");
		Image img = new Image(is);
		final ImageView imageView = new ImageView(img);

        final Label label = new Label();
        label.textProperty().bind(button.textProperty());
		label.getStyleClass().addAll("OpenPatricianSmallWaxButtonLabeled", "toggledOn");
		label.setFont(button.getFont());
		label.setOnMouseReleased(evt -> {
			button.setToggled(!button.getToggled());
		});
		label.onMouseClickedProperty().bind(button.onActionProperty());

		button.toggledProperty().addListener((observable, oldValue, newValue) -> {
			if (newValue) {
				label.getStyleClass().remove("toggledOn");
				label.getStyleClass().add("toggledOff");
			} else {
				label.getStyleClass().remove("toggledOff");
				label.getStyleClass().add("toggledOn");
			}
		});

		label.textProperty().bind(button.textProperty());
		imageView.onMouseReleasedProperty().bind(button.onActionProperty());
		
		StackPane stack = new StackPane();
		stack.getChildren().addAll(imageView, label);
		Group group = new Group(stack);
		
		group.setManaged(false);

        button.setPrefHeight(img.getHeight());
        button.setPrefWidth(img.getWidth());

		getChildren().add(group);


	}


}
