package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

import java.io.InputStream;
import java.util.List;

@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianSpinnerSkin extends
		SkinBase<OpenPatricianSpinner> {
	
	private TextSizingUtility sizing = new TextSizingUtility();

	public OpenPatricianSpinnerSkin(final OpenPatricianSpinner spinner) {
		super(spinner);
		
		// TODO aho Sep 22, 2013: extract
		Dimension2D dim4heigth = sizing.calculate(1, spinner.getFont());
		double width = 10; // padding
		String firstValue = "";
		if (!spinner.getOptions().isEmpty()) {
            List<String> l = spinner.getOptions();
			firstValue = l.get(0);
			spinner.selectedIndexProperty().set(0);
		}
		final TextField textField = new TextField(firstValue);
        final ObservableList<String> options = spinner.getOptions();
        for (String word : options) {
			Dimension2D dim4width = sizing.calculate(word, spinner.getFont());
			if (dim4width.getWidth() > width) {
				width = dim4width.getWidth() + 10; // padding
			}
		}
		double maxWidth = spinner.getMaxWidth(); // This must be initialized before appended to the scene
		final Dimension2D dim = new Dimension2D(Math.max(width, maxWidth), dim4heigth.getHeight());

		
		HBox hbox = new HBox();
		textField.getStyleClass().add("openPatricianSpinner");
		textField.setMinWidth(dim.getWidth());
		textField.setMaxSize(dim.getWidth(), dim.getHeight());
		textField.setEditable(false);

		
		InputStream is = getClass().getResourceAsStream("SlabUp.png");
		Image img = new Image(is);
		double imgWidth = img.getWidth();
		final ImageView imgViewUp = new ImageView(img);
		is = getClass().getResourceAsStream("SlabDown.png");
		img = new Image(is);
		final ImageView imgViewDown = new ImageView(img);
		final double additionalWidth = Math.max(img.getWidth(), imgWidth);

		
		is = getClass().getResourceAsStream("InputPlank.jpg");
		img = new Image(is,dim.getWidth()+additionalWidth, dim.getHeight(), false, true);
		final ImageView imgViewPlank = new ImageView(img);
		
		Group textGroup = new Group(textField);
		
		VBox vbox = new VBox();
		vbox.getChildren().addAll(imgViewUp, imgViewDown);
		
		hbox.getChildren().addAll(textGroup, vbox);
		Group background = new Group(imgViewPlank,hbox);
		imgViewUp.setOnMouseReleased(new EventHandler<MouseEvent>() {

			@Override
			public void handle(MouseEvent event) {
				ObservableList<String> options = spinner.getOptions();
				if (!options.isEmpty()) {
					if (spinner.getSelectedIndex() > 0) {
						spinner.decSelectedIndex();
						String newDisplayValue = options.get(spinner.getSelectedIndex());
						textField.setText(newDisplayValue);
					}
				}				
			}
		});
		
		imgViewDown.setOnMouseReleased(new EventHandler<MouseEvent>() {

			@Override
			public void handle(MouseEvent event) {
				ObservableList<String> options = spinner.getOptions();
				if (!options.isEmpty()) {
					if (spinner.getSelectedIndex() < options.size()) {
						spinner.incSelectedIndex();
						String newDisplayValue = options.get(spinner.getSelectedIndex());
						textField.setText(newDisplayValue);
					}
				}
			}
		});
		
		background.setManaged(false);

		getChildren().add(background);

	}

}
