package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import javafx.geometry.HPos;

import java.util.ArrayList;
import java.util.List;
/**
 * Container class holing the horizontal alignments for all cells within a row.
 * Default alignment is left.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 16, 2013
 *
 */
@ClassCategory(EClassCategory.MODEL)
class RowCellAlignement {
	@ListType(HPos.class)
	private final List<HPos> alignment;
	
	public RowCellAlignement(int nbColumns) {
		alignment = new ArrayList<>();
		for (int i = 0; i < nbColumns; i++) {
			alignment.add(HPos.LEFT);
		}
	}
	/**
	 * Set the alignment of column index.
	 * @param index
	 * @param pos
	 */
	public void setAligenment(int index, HPos pos) {
		alignment.remove(index);
		alignment.add(index, pos);
	}
	
	public HPos getAligenment(int column) {
		return alignment.get(column);
	}

}
