package ch.sahits.game.javafx.util;

import javafx.scene.text.Font;
import ch.sahits.game.javafx.control.ScrollPaneContent;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;

/**
 * Factory for creating the notice board contents.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 3, 2013
 *
 */
public interface INoticeBoardFactory {
	/**
	 * Populate <code>content</code> based on the <code>destinction</code>.
	 * @param content to be populated.
	 * @param destinction flag used to decide on the content.
	 */
	void populateNoticeBoardContent(ScrollPaneContent content, INoticeBoardDestinction destinction, ICityPlayerProxyJFX proxy, Font font);
}
