package ch.sahits.game.openpatrician.dialog;

import ch.sahits.game.javafx.service.DecoratedTextFactory;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

/**
 * Base class for Open Patrician dialogs.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 14, 2013
 *
 */
public class Dialog extends Group {
	public static final int WIDTH = 518;
	public static final int HEIGHT = 691;
	public static final int FRAME_BORDER = 15;
	public static final int WRAPPING_WIDTH = WIDTH - 4 * FRAME_BORDER;
	@Autowired
	protected DecoratedTextFactory decoratedTextFactory;
	// TODO aho Nov 14, 2013: make dis configruable
	private final ReadOnlyObjectProperty<Font> font;
	private final Group content;
	
	public Dialog(final Font font) {
		setManaged(false);
		this.font = new ReadOnlyObjectPropertyBase<Font>() {

			@Override
			public Object getBean() {
				return Dialog.this;
			}

			@Override
			public String getName() {
				return "font";
			}

			@Override
			public Font get() {
				return font;
			}
		};
        getStylesheets().add(Dialog.class.getResource("Dialog.css").toExternalForm());
		InputStream is = Dialog.class.getResourceAsStream("fringe.jpg");
		Image img = new Image(is);
		ImageView imgView = new ImageView(img);
		content = new Group();
		getChildren().addAll(imgView, content);
	}
	
	public ReadOnlyObjectProperty<Font> fontProperty() {
		return font;
	}

	public ObservableList<Node> getContent() {
		return content.getChildren();
	}

	public void replaceContent(Node... nodes){
		replaceContent(Arrays.asList(nodes));
	}
	public void replaceContent(List<Node> nodes){
		content.getChildren().clear();
		content.getChildren().addAll(nodes);
	}
}
