package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;

import java.net.URL;
/**
 * Base class for buttons in openPatricain.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 14, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianButton extends Control {

	protected final StringProperty text;
	protected final ReadOnlyObjectProperty<Font> currentFont;
	protected final ObjectProperty<EventHandler<MouseEvent>> onAction;

	public OpenPatricianButton(String text,
			final Font font) {
		super();
		this.text = new SimpleStringProperty(this, "text", text);
		this.currentFont = new ReadOnlyObjectPropertyBase<Font>() {

			@Override
			public Object getBean() {
				return this;
			}

			@Override
			public String getName() {
				return "currentFont";
			}

			@Override
			public Font get() {
				return font;
			}
		};
		this.onAction = new SimpleObjectProperty<EventHandler<MouseEvent>>(this, "onAction");
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	public String getUserAgentStylesheet() {
	    URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	public StringProperty textProperty() {
		return text;
	}

	public String getText() {
		return text.get();
	}

	public void setText(String text) {
		this.text.set(text);
	}

	public Font getFont() {
		return currentFont.get();
	}

	public ObjectProperty<EventHandler<MouseEvent>> onActionProperty() {
		return onAction;
	}

	public EventHandler<MouseEvent> getOnAction() {
		return onAction.get();
	}

	public void setOnAction(EventHandler<MouseEvent> onAction) {
		this.onAction.set(onAction);
	}

}