package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.geometry.HPos;

/**
 * Table header row.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 16, 2013
 *
 */
@ClassCategory(EClassCategory.MODEL)
public class TableHeader extends TableRow {

	private RowCellAlignement headerAlignment;
    private int nbCols;
	public TableHeader(int nbCols) {
		headerAlignment = new RowCellAlignement(nbCols);
        this.nbCols = nbCols;
	}
	public void setAligenment(int index, HPos pos) {
		headerAlignment.setAligenment(index, pos);
	}
	public HPos getAligenment(int column) {
		return headerAlignment.getAligenment(column);
	}

    public int getNbCols() {
        return nbCols;
    }
}
