/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.util;

import org.junit.Assert;
import org.junit.Test;

public class AngleTest {
    @Test
    public void sinusIncreasing0to90() {
        Double sinus = null;
        for (int angle = 0; angle <= 90; ++angle) {
            double newSinus = this.calculateSinus(angle);
            if (sinus != null) {
                Assert.assertTrue((String)("The new Sinus " + newSinus + " is not larger than the old (" + sinus + ") at angle " + angle), (sinus < newSinus ? 1 : 0) != 0);
                System.out.println("Sinus of " + angle + ": " + newSinus);
            }
            sinus = newSinus;
        }
    }

    @Test
    public void elevationOverHorizonIncreases0to45() {
        int angle = 1;
        double heigth = 0.0;
        double radius = 100.0;
        while (angle <= 45) {
            double newHeigth = this.calculateHeigthOverHorizon(angle, radius);
            Assert.assertTrue((String)("New heigth " + newHeigth + " is not larger than old (" + heigth + ") at angle " + angle), (newHeigth > heigth ? 1 : 0) != 0);
            heigth = newHeigth;
            System.out.println("Heigth at " + ++angle + ": " + newHeigth);
        }
    }

    @Test
    public void elevationOverHorizonDecreases45to90() {
        int angle = 46;
        double heigth = 100.0;
        double radius = 100.0;
        while (angle <= 90) {
            double newHeigth = this.calculateHeigthOverHorizon(angle, radius);
            Assert.assertTrue((String)("New heigth " + newHeigth + " is not larger than old (" + heigth + ") at angle " + angle), (newHeigth < heigth ? 1 : 0) != 0);
            heigth = newHeigth;
            System.out.println("Heigth at " + ++angle + ": " + newHeigth);
        }
    }

    @Test
    public void testElevationOverHorizon90to180() {
        double radius = 100.0;
        for (int angle = 90; angle <= 180; ++angle) {
            double expected = this.calculateHeigthOverHorizon(180 - angle, radius);
            double actual = this.calculateHeigthOverHorizon(angle, radius);
            Assert.assertEquals((double)expected, (double)actual, (double)0.001);
            System.out.println("Expected height " + expected + " at " + angle + " is actually " + actual);
        }
    }

    @Test
    public void calculateHeigthAt45() {
        int angle = 45;
        double radius = 100.0;
        double heigth = this.calculateHeigthOverHorizon(angle, radius);
        double baseHypotenuse = Math.sqrt(Math.pow(radius, 2.0) * 2.0);
        double expectedHeigth = Math.sqrt(radius * radius - baseHypotenuse * baseHypotenuse / 4.0);
        Assert.assertEquals((double)expectedHeigth, (double)heigth, (double)0.001);
    }

    private double calculateSinus(int angle) {
        double sin = Math.sin(Math.toRadians(angle));
        return sin;
    }

    private double calculateHeigthOverHorizon(int angle, double radius) {
        if (angle > 90 && angle <= 180) {
            angle = 180 - angle;
        }
        if (angle > 45 && angle <= 90) {
            angle += 90;
        }
        return radius * this.calculateSinus(angle);
    }
}

