package ch.sahits.game.javafx.bindings;

import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.StringProperty;
/**
 * Binding parting a String (base 10) into an integer.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 2, 2013
 *
 */
public class StringToIntegerBinding extends IntegerBinding {
	private final StringProperty stringValue;
	
	public StringToIntegerBinding(StringProperty stringValue) {
		super();
		this.stringValue = stringValue;
		bind(stringValue);
	}	

	@Override
	protected int computeValue() {
		try {
			int value = Integer.parseInt(stringValue.get());
			return value;
		} catch (NumberFormatException e) {
			return 0;
		}
	}

}
