package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.bindings.StringToIntegerBinding;
import ch.sahits.game.javafx.bindings.ZeroAmountBooleanBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
/**
 * Coin price which is only visible when the amount is larger than zero.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 6, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class CoinPrice extends CoinPriceAlwaysVisible {

	public CoinPrice() {
		super();

		IntegerProperty intAmount = new SimpleIntegerProperty();
		intAmount.bind(new StringToIntegerBinding(amountProperty()));
		visibleProperty().bind(new ZeroAmountBooleanBinding(intAmount));
	}
}
