package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

import java.io.InputStream;
import java.util.List;

@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianSpinnerSkin extends
		SkinBase<OpenPatricianSpinner> {

	private final OpenPatricianSpinner spinner;
	
	private TextSizingUtility sizing = new TextSizingUtility();
	private final TextField textField;
	private ImageView imgViewPlank;
	private final double additionalWidth;

	public OpenPatricianSpinnerSkin(final OpenPatricianSpinner spinner) {
		super(spinner);
		this.spinner = spinner;
		
		String firstValue = "";
		if (!spinner.getOptions().isEmpty()) {
            List<String> l = spinner.getOptions();
			firstValue = l.get(0);
			spinner.selectedIndexProperty().set(0);
		}
		textField = new TextField(firstValue);
		Font font = spinner.getFont();
		spinner.fontProperty().addListener((observalbe, oldValue, newValue) -> {
			calculateNewDimension((Font)newValue);
		});
		calculateNewDimension(font);

		// if the options change the content of the text field changes as well
		spinner.optionsProperty().addListener((observable, oldValue, newValue) -> {
			String internalFirst = "";
			if (!spinner.getOptions().isEmpty()) {
				List<String> l = spinner.getOptions();
				internalFirst = l.get(0);
				spinner.selectedIndexProperty().set(0);
			}
			textField.setText(internalFirst);
			calculateNewDimension(font);
		});


		
		HBox hbox = new HBox();
		textField.getStyleClass().add("openPatricianSpinner");
		textField.setEditable(false);

		
		InputStream is = getClass().getResourceAsStream("SlabUp.png");
		Image img = new Image(is);
		double imgWidth =  img.getWidth();
		final ImageView imgViewUp = new ImageView(img);
		is = getClass().getResourceAsStream("SlabDown.png");
		img = new Image(is);
		final ImageView imgViewDown = new ImageView(img);
		additionalWidth = Math.max(img.getWidth(), imgWidth);

		
		Group textGroup = new Group(textField);
		
		VBox vbox = new VBox();
		vbox.getChildren().addAll(imgViewUp, imgViewDown);
		
		hbox.getChildren().addAll(textGroup, vbox);
		Group background = new Group(imgViewPlank,hbox);
		imgViewUp.setOnMouseReleased(event -> {
            if (isNumeticalOptions()) {
                selectNextInList(spinner);
            } else {
                selectPreviousInList(spinner);
            }
        });
		
		imgViewDown.setOnMouseReleased(event -> {
            if (isNumeticalOptions()) {
                selectPreviousInList(spinner);
            } else {
                selectNextInList(spinner);
            }
        });
		
		background.setManaged(false);

		getChildren().add(background);

	}

    private boolean isNumeticalOptions() {
        String str = (String)spinner.getOptions().get(0);
        return str.matches("-?\\d+(\\.\\d+)?");  //match a number with optional '-' and decimal.
    }

    private void selectPreviousInList(OpenPatricianSpinner spinner) {
        ObservableList<String> options1 = spinner.getOptions();
        if (!options1.isEmpty()) {
            if (spinner.getSelectedIndex() > 0) {
                spinner.decSelectedIndex();
                String newDisplayValue = options1.get(spinner.getSelectedIndex());
                textField.setText(newDisplayValue);
            }
        }
    }

    private void selectNextInList(OpenPatricianSpinner spinner) {
        ObservableList<String> options1 = spinner.getOptions();
        if (!options1.isEmpty()) {
            if (spinner.getSelectedIndex() < options1.size()) {
                spinner.incSelectedIndex();
                String newDisplayValue = options1.get(spinner.getSelectedIndex());
                textField.setText(newDisplayValue);
            }
        }
    }

    private void calculateNewDimension(Font font) {
		double width = 10; // padding
		final ObservableList<String> options = spinner.getOptions();
		Dimension2D dim4heigth = sizing.calculate(1, font);
		for (String word : options) {
			Dimension2D dim4width = sizing.calculate(word, font);
			if (dim4width.getWidth() > width) {
				width = dim4width.getWidth() + 10 + 20; // padding + text inset
			}
		}
		double maxWidth = spinner.getMaxWidth(); // This must be initialized before appended to the scene
		final Dimension2D dim = new Dimension2D(Math.max(width, maxWidth), dim4heigth.getHeight());

		textField.setMinWidth(dim.getWidth());
		textField.setMaxSize(dim.getWidth(), dim.getHeight());

		InputStream is = getClass().getResourceAsStream("InputPlank.jpg");
		Image img = new Image(is,dim.getWidth()+additionalWidth, dim.getHeight(), false, true);
		if (imgViewPlank == null) {
			imgViewPlank = new ImageView(img);
		} else {
			imgViewPlank.setImage(img);
		}

	}

}
