package ch.sahits.game.javafx.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
/**
 * This event handler handels mouse click events, to figure out the location of the 
 * mouse click. This event handler should only be used on development time to define
 * bounderies of controlling shapes, that will handle the mouse event directly and consume it.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jul 21, 2013
 *
 */
@ClassCategory(EClassCategory.HANDLER)
public class MouseClickLocationEventHandler implements EventHandler<MouseEvent> {

	@Override
	public void handle(MouseEvent event) {
		System.out.println("Clicked relative to the scene at: "+event.getSceneX()+","+event.getSceneY());
		
	}

}
