package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.control.Label;
import lombok.Getter;
import lombok.Setter;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * Representing the model for the menu displayed in the notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@ClassCategory(EClassCategory.MODEL)
public class NoticeBoardMenu {
    @Getter
    @Setter
    private Label title;
    @Getter
    private final ENoticeBoardType type;
    private ObservableSet<NoticeBoardMenuEntry> menuEntries = FXCollections.observableSet(new LinkedHashSet<>());

    public NoticeBoardMenu(ENoticeBoardType type) {
        this.type = type;
    }

    public void setMenuEntries(LinkedHashSet<NoticeBoardMenuEntry> menuEntries) {
        this.menuEntries.clear();
        this.menuEntries.addAll(menuEntries);
    }
    public Set<NoticeBoardMenuEntry> getMenuEntries() {
        return menuEntries;
    }
    public ObservableSet<NoticeBoardMenuEntry> menuEntriesProperty() {
        return menuEntries;
    }
    public void disableAll() {
        for (NoticeBoardMenuEntry menuEntry : menuEntries) {
            menuEntry.disabledProperty().setValue(true);
        }
    }
    public void enableAll() {
        for (NoticeBoardMenuEntry menuEntry : menuEntries) {
            menuEntry.disabledProperty().setValue(false);
        }
    }

    public void deselctAll() {
        for (NoticeBoardMenuEntry menuEntry : menuEntries) {
            menuEntry.setSelected(false);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NoticeBoardMenu)) {
            return false;
        }

        NoticeBoardMenu that = (NoticeBoardMenu) o;

        if (getTitle() != null ? !getTitle().getText().equals(that.getTitle().getText()) : that.getTitle() != null) {
            return false;
        }
        return getType() == that.getType();

    }

    @Override
    public int hashCode() {
        int result = getTitle() != null ? getTitle().hashCode() : 0;
        result = 31 * result + (getType() != null ? getType().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "NoticeBoardMenu{" +
                "title=" + title.getText() +
                ", type=" + type +
                '}';
    }
}
