package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
public abstract class AbstractNoticeBoardMenuProvider {
    @Autowired
    protected ApplicationContext context;
    @Autowired
    protected DecoratedTextFactory textFactory;
    protected NoticeBoardMenuEntry createNoticeBoardEntry(String s, EDialogType type) {
        DecoratedText label = textFactory.createSimpleDecoratedText(s);
        NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(type);
        if (type.isShouldOpenByDefault()) {
            entry.setSelected(true);
        }
        entry.setLabel(label);
        Object[] args = new Object[]{type};
        final Runnable runnable1 = (Runnable) context.getBean("viewChangeActionRunnable", args);
        EventHandler<MouseEvent> openDialogEvenHandler = evt -> {
            runnable1.run();
        };
        entry.setOnMouseSelect(openDialogEvenHandler);
        return entry;
    }
}
