package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Utility to calculate the size of a text and add an elipsis of '...' at the end, so
 * everything can be displayed.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Mar 07, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class TextEllipsisCalculator {
    private final static String ELLIPSIS = "...";
    @Autowired
    private TextSizingUtility sizing;

    public String calculateEllipsis(Font font, final String text, double maxWidth){
        double ellipsisWidth = sizing.calculate(ELLIPSIS, font).getWidth();
        int guessNbChars = Math.min(sizing.guessNumberOfCharacters(maxWidth - ellipsisWidth, font), text.length() - 1);
        String substr = text.substring(0, guessNbChars)+ELLIPSIS;
        boolean reducedNbCharacters = false;
        while (sizing.calculate(substr, font).getWidth() > maxWidth) {
            guessNbChars--;
            reducedNbCharacters = true;
            substr = text.substring(0, guessNbChars)+ELLIPSIS;
        }
        // The string is shorter and it is not due to the above while loop
        if (!reducedNbCharacters) {
            while (sizing.calculate(substr, font).getWidth() < maxWidth && guessNbChars < text.length() - 1) {
                guessNbChars++;
                substr = text.substring(0, guessNbChars)+ELLIPSIS;
            }
        }
        if (sizing.calculate(substr, font).getWidth() > maxWidth) {
            substr = text.substring(0, guessNbChars - 1)+ELLIPSIS;
        }
        return substr;
    }
}
