/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.service.ShipService;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardShipSelectionMenuProviderTest {
    @Mock
    private Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private DecoratedTextFactory textFactory;
    @Mock
    private ShipService shipService;
    @Mock
    private ApplicationContext context;
    @InjectMocks
    private NoticeBoardShipSelectionMenuProvider menuProvider;

    @Before
    public void setup() {
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"Text");
        DecoratedText dt = new DecoratedText();
        BDDMockito.given((Object)this.textFactory.createDecoratedText(Matchers.anyString(), (Map)Matchers.any())).willReturn((Object)dt);
    }

    @Test
    public void shouldProvideMenuEntryForSingleShips() {
        IShip ship1 = (IShip)Mockito.mock(IShip.class);
        IShip ship2 = (IShip)Mockito.mock(IShip.class);
        IShip ship3 = (IShip)Mockito.mock(IShip.class);
        IShip ship4 = (IShip)Mockito.mock(IShip.class);
        IShip ship5 = (IShip)Mockito.mock(IShip.class);
        IShip ship6 = (IShip)Mockito.mock(IShip.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)ship1.getName()).willReturn((Object)"Ship name 1");
        BDDMockito.given((Object)ship2.getName()).willReturn((Object)"Ship name 2");
        BDDMockito.given((Object)ship3.getName()).willReturn((Object)"Ship name 3");
        BDDMockito.given((Object)ship4.getName()).willReturn((Object)"Ship name 4");
        BDDMockito.given((Object)ship5.getName()).willReturn((Object)"Ship name 5");
        BDDMockito.given((Object)ship6.getName()).willReturn((Object)"Ship name 6");
        BDDMockito.given((Object)ship1.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship2.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship3.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship4.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship5.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship6.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship1.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)ship2.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)ship3.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)ship4.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)ship5.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)ship6.getOwner()).willReturn((Object)player);
        ObservableList ships = FXCollections.observableArrayList();
        ships.add((Object)ship1);
        ships.add((Object)ship2);
        ships.add((Object)ship3);
        ships.add((Object)ship4);
        ships.add((Object)ship5);
        ships.add((Object)ship6);
        ICaptain captain = (ICaptain)Mockito.mock(ICaptain.class);
        BDDMockito.given((Object)ship1.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)ship2.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)ship3.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)ship4.getCaptian()).willReturn(Optional.of(captain));
        BDDMockito.given((Object)ship5.getCaptian()).willReturn(Optional.of(captain));
        BDDMockito.given((Object)ship6.getCaptian()).willReturn(Optional.of(captain));
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship1)).willReturn((Object)0);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship2)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship3)).willReturn((Object)6);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship4)).willReturn((Object)0);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship5)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship6)).willReturn((Object)6);
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)proxy.getActiveShip()).willReturn((Object)ship2);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)proxy.getPlayersNavalVessels()).willReturn((Object)ships);
        LinkedHashSet entryList = this.menuProvider.createMenuEntries(proxy, ENoticeBoardType.SHIP_SELECTION);
        ((MessageSource)Mockito.verify((Object)this.messageSource)).getMessage("ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship", new Object[]{"Ship name 1", 350}, java.util.Locale.ENGLISH);
        int index = 0;
        for (NoticeBoardMenuEntry entry : entryList) {
            if (index == 1) {
                Assert.assertTrue((boolean)entry.getSelected());
            } else {
                Assert.assertFalse((boolean)entry.getSelected());
            }
            Assert.assertFalse((boolean)entry.getDisabled());
            ++index;
        }
    }

    @Test
    public void shouldAddMenuEntryForConvoyAndTwoShipsCaptainSmallWeaponsDifferentConvoyOwner() {
        IShip ship1 = (IShip)Mockito.mock(IShip.class);
        IShip ship2 = (IShip)Mockito.mock(IShip.class);
        IConvoy convoy = (IConvoy)Mockito.mock(IConvoy.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        IPlayer otherPlayer = (IPlayer)Mockito.mock(IPlayer.class);
        BDDMockito.given((Object)ship1.getName()).willReturn((Object)"Ship name 1");
        BDDMockito.given((Object)ship2.getName()).willReturn((Object)"Ship name 2");
        BDDMockito.given((Object)convoy.getName()).willReturn((Object)"Ship name 1");
        BDDMockito.given((Object)ship1.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship2.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)convoy.getCapacity()).willReturn((Object)700);
        BDDMockito.given((Object)ship1.getOwner()).willReturn((Object)otherPlayer);
        BDDMockito.given((Object)ship2.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)convoy.getOwner()).willReturn((Object)otherPlayer);
        ObservableList ships = FXCollections.observableArrayList();
        ships.add((Object)convoy);
        ArrayList<IShip> convoyShips = new ArrayList<IShip>();
        convoyShips.add(ship1);
        convoyShips.add(ship2);
        ICaptain captain = (ICaptain)Mockito.mock(ICaptain.class);
        BDDMockito.given((Object)convoy.getShips()).willReturn(convoyShips);
        BDDMockito.given((Object)ship1.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)ship2.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)convoy.getCaptian()).willReturn(Optional.of(captain));
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship1)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship2)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)convoy)).willReturn((Object)4);
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)proxy.getActiveShip()).willReturn((Object)convoy);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)proxy.getPlayersNavalVessels()).willReturn((Object)ships);
        LinkedHashSet entryList = this.menuProvider.createMenuEntries(proxy, ENoticeBoardType.SHIP_SELECTION);
        ((MessageSource)Mockito.verify((Object)this.messageSource)).getMessage("ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.smallstrangth.capacity", new Object[]{"Ship name 1", 700}, java.util.Locale.ENGLISH);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)2))).getMessage((String)Matchers.eq((Object)"ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.shipinconvoy"), (Object[])Matchers.any(), (java.util.Locale)Matchers.eq((Object)java.util.Locale.ENGLISH));
        int index = 0;
        for (NoticeBoardMenuEntry entry : entryList) {
            if (index == 2) {
                Assert.assertFalse((boolean)entry.getDisabled());
            } else {
                Assert.assertTrue((boolean)entry.getDisabled());
            }
            ++index;
        }
    }

    @Test
    public void shouldAddMenuEntryForConvoyAndTwoShipsCaptainBigWeaponsDifferentConvoyOwner() {
        IShip ship1 = (IShip)Mockito.mock(IShip.class);
        IShip ship2 = (IShip)Mockito.mock(IShip.class);
        IConvoy convoy = (IConvoy)Mockito.mock(IConvoy.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        IPlayer otherPlayer = (IPlayer)Mockito.mock(IPlayer.class);
        BDDMockito.given((Object)ship1.getName()).willReturn((Object)"Ship name 1");
        BDDMockito.given((Object)ship2.getName()).willReturn((Object)"Ship name 2");
        BDDMockito.given((Object)convoy.getName()).willReturn((Object)"Ship name 1");
        BDDMockito.given((Object)ship1.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)ship2.getCapacity()).willReturn((Object)350);
        BDDMockito.given((Object)convoy.getCapacity()).willReturn((Object)700);
        BDDMockito.given((Object)ship1.getOwner()).willReturn((Object)otherPlayer);
        BDDMockito.given((Object)ship2.getOwner()).willReturn((Object)player);
        BDDMockito.given((Object)convoy.getOwner()).willReturn((Object)otherPlayer);
        ObservableList ships = FXCollections.observableArrayList();
        ships.add((Object)convoy);
        ArrayList<IShip> convoyShips = new ArrayList<IShip>();
        convoyShips.add(ship1);
        convoyShips.add(ship2);
        ICaptain captain = (ICaptain)Mockito.mock(ICaptain.class);
        BDDMockito.given((Object)convoy.getShips()).willReturn(convoyShips);
        BDDMockito.given((Object)ship1.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)ship2.getCaptian()).willReturn(Optional.empty());
        BDDMockito.given((Object)convoy.getCaptian()).willReturn(Optional.of(captain));
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship1)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship2)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)convoy)).willReturn((Object)4);
        BDDMockito.given((Object)this.shipService.calculateShipsWeaponsStrength((INavigableVessel)convoy)).willReturn((Object)20);
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)proxy.getActiveShip()).willReturn((Object)convoy);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)proxy.getPlayersNavalVessels()).willReturn((Object)ships);
        LinkedHashSet entryList = this.menuProvider.createMenuEntries(proxy, ENoticeBoardType.SHIP_SELECTION);
        ((MessageSource)Mockito.verify((Object)this.messageSource)).getMessage("ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.bigstrangth.capacity", new Object[]{"Ship name 1", 700}, java.util.Locale.ENGLISH);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)2))).getMessage((String)Matchers.eq((Object)"ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.shipinconvoy"), (Object[])Matchers.any(), (java.util.Locale)Matchers.eq((Object)java.util.Locale.ENGLISH));
        int index = 0;
        for (NoticeBoardMenuEntry entry : entryList) {
            if (index == 2) {
                Assert.assertFalse((boolean)entry.getDisabled());
            } else {
                Assert.assertTrue((boolean)entry.getDisabled());
            }
            ++index;
        }
    }
}

