/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;

@ClassCategory(value={EClassCategory.JAVAFX})
public class ImageFactory {
    @MapType(key=Float.class, value=String.class)
    private static LinkedHashMap<Float, String> slabMap = new LinkedHashMap();
    @MapType(key=Float.class, value=String.class)
    private static LinkedHashMap<Float, String> slabExtMap = new LinkedHashMap();

    private String getFileName(int width, int height) {
        float f = (float)width * 1.0f / (float)height;
        String minDistFileName = "StoneSlabBorderless.png";
        return this.getFileName(f, minDistFileName, slabMap);
    }

    private String getFileName(float f, String defaultFileName, HashMap<Float, String> fNames) {
        float minDist = Float.MAX_VALUE;
        for (Map.Entry<Float, String> entry : fNames.entrySet()) {
            float diff = Math.abs(entry.getKey().floatValue() - f);
            if (!(diff < minDist)) continue;
            minDist = diff;
            defaultFileName = entry.getValue();
        }
        return defaultFileName;
    }

    public Image getSlabImage(Dimension2D dim) {
        String fileName = this.getFileName((int)Math.rint(dim.getWidth()), (int)Math.rint(dim.getHeight()));
        InputStream is = this.getClass().getResourceAsStream(fileName);
        return new Image(is, dim.getWidth(), dim.getHeight(), false, true);
    }

    public String getFileNameExt(double width, double height, int capWidth) {
        float f = (float)(((double)capWidth - width) / height);
        return this.getFileName(f, "StoneSlabExt.png", slabExtMap);
    }

    static {
        slabMap.put(Float.valueOf(1.3f), "StoneSlab_1_3.png");
        slabMap.put(Float.valueOf(2.2f), "StoneSlab_2_2.png");
        slabMap.put(Float.valueOf(3.5f), "StoneSlab_3_5.png");
        slabMap.put(Float.valueOf(4.1f), "StoneSlab_4_1.png");
        slabMap.put(Float.valueOf(4.7f), "StoneSlab_4_7.png");
        slabMap.put(Float.valueOf(5.8f), "StoneSlab_5_8.png");
        slabExtMap.put(Float.valueOf(1.1f), "StoneSlabExt_1_1.png");
        slabExtMap.put(Float.valueOf(2.2f), "StoneSlabExt_2_2.png");
        slabExtMap.put(Float.valueOf(2.7f), "StoneSlabExt_2_7.png");
        slabExtMap.put(Float.valueOf(3.0f), "StoneSlabExt_3_0.png");
        slabExtMap.put(Float.valueOf(3.1f), "StoneSlabExt_3_1.png");
        slabExtMap.put(Float.valueOf(3.6f), "StoneSlabExt_3_6.png");
    }
}

