/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.NoticeBoardMenu;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

@ClassCategory(value={EClassCategory.JAVAFX})
public class NoticeBoardScrollPaneContent
extends VBox {
    private static final String DEFAULT_LABEL_STYLE = "scrollPaneContent-label";
    private static final String ACTIVE_LABEL_STYLE = "scrollPaneContent-label-active";
    private static final String DISABLED_LABEL_STYLE = "scrollPaneContent-label-disabled";
    private DoubleProperty parentWidth = new SimpleDoubleProperty((Object)this, "parentWidth");

    public NoticeBoardScrollPaneContent() {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm());
    }

    public void setContent(Optional<NoticeBoardMenu> optMenu) {
        this.getChildren().clear();
        if (optMenu.isPresent()) {
            NoticeBoardMenu menu = optMenu.get();
            Label title = menu.getTitle();
            title.getStyleClass().add((Object)"scrollPaneContent-title");
            this.getChildren().add((Object)title);
            for (NoticeBoardMenuEntry menuItem : menu.getMenuEntries()) {
                DecoratedText label = menuItem.getLabel();
                this.getChildren().add((Object)label);
                if (menuItem.getDisabled()) {
                    this.applyStyle(label, DISABLED_LABEL_STYLE);
                } else if (menuItem.getSelected()) {
                    this.applyStyle(label, ACTIVE_LABEL_STYLE);
                } else {
                    this.applyStyle(label, DEFAULT_LABEL_STYLE);
                }
                menuItem.selectedProperty().addListener((observable, oldValue, newValue) -> this.setSelectedStyle(label, (Boolean)newValue));
                menuItem.disabledProperty().addListener((observable, oldValue, newValue) -> this.setDisabledStyle(label, (Boolean)newValue));
            }
        }
    }

    private void applyStyle(DecoratedText text, String styleClass) {
        text.applyTextStyle(true, styleClass);
    }

    private void removeStyle(DecoratedText text, String styleClass) {
        text.applyTextStyle(false, styleClass);
    }

    private void setSelectedStyle(DecoratedText label, Boolean newValue) {
        if (newValue.booleanValue()) {
            this.applyStyle(label, ACTIVE_LABEL_STYLE);
            this.removeStyle(label, DEFAULT_LABEL_STYLE);
            this.removeStyle(label, DISABLED_LABEL_STYLE);
        } else {
            this.applyStyle(label, DEFAULT_LABEL_STYLE);
            this.removeStyle(label, ACTIVE_LABEL_STYLE);
            this.removeStyle(label, DISABLED_LABEL_STYLE);
        }
    }

    private void setDisabledStyle(DecoratedText label, Boolean newValue) {
        if (newValue.booleanValue()) {
            label.getStyleClass().add((Object)DISABLED_LABEL_STYLE);
            label.getStyleClass().remove((Object)ACTIVE_LABEL_STYLE);
            label.getStyleClass().remove((Object)DEFAULT_LABEL_STYLE);
        } else {
            label.getStyleClass().add((Object)DEFAULT_LABEL_STYLE);
            label.getStyleClass().remove((Object)ACTIVE_LABEL_STYLE);
            label.getStyleClass().remove((Object)DISABLED_LABEL_STYLE);
        }
    }
}

