/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.skin.OpenPatricianSliderSkin;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.text.Font;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianSlider
extends Control {
    @ListType(value=String.class)
    private final ObservableList<String> values = new SimpleListProperty((Object)this, "options", FXCollections.observableList(new ArrayList()));
    private final IntegerProperty selectedIndex;
    private final ReadOnlyIntegerProperty initialWidth;
    @ObjectPropertyType(value=Font.class)
    private StyleableObjectProperty<Font> font;

    public OpenPatricianSlider(int width) {
        this.initialWidth = new SimpleIntegerProperty((Object)this, "initialWidth", width);
        this.selectedIndex = new SimpleIntegerProperty((Object)this, "selectedIndex", -1);
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public String getUserAgentStylesheet() {
        URL cssURL = ((Object)((Object)this)).getClass().getResource("/ch/sahits/game/javafx/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css");
        return cssURL.toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new OpenPatricianSliderSkin(this);
    }

    public ObservableList<String> valuesProperty() {
        return this.values;
    }

    public void setValues(List<String> options) {
        this.values.setAll(options);
        this.selectedIndex.set(0);
    }

    public void setValues(String ... options) {
        this.values.setAll((Object[])options);
        this.selectedIndex.set(0);
    }

    public String getSelectedValue() {
        return (String)this.values.get(this.getSelectedIndex());
    }

    public IntegerProperty selectedIndexProperty() {
        return this.selectedIndex;
    }

    public int getSelectedIndex() {
        return this.selectedIndex.get();
    }

    public int getInitialWidth() {
        return this.initialWidth.get();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return OpenPatricianSlider.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<OpenPatricianSlider, Font> FONT = new CssMetaData<OpenPatricianSlider, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(OpenPatricianSlider control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(OpenPatricianSlider control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

