/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.PaginationV2;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.model.Text;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Font;
import javafx.util.Builder;

@ClassCategory(value={EClassCategory.JAVAFX})
public class PaginationV2Builder
implements Builder<PaginationV2> {
    private DoubleProperty contentMaxWidth;
    private DoubleProperty contentMaxHeight;
    @ObjectPropertyType(value=Insets.class)
    private ObjectProperty<Insets> paddingLocal;
    private StringProperty backButtonLabel;
    private StringProperty nextButtonLabel;
    @ObjectPropertyType(value=Text.class)
    private ObjectProperty<Text> text;
    private ReadOnlyObjectProperty<Font> navigationLabelFont;
    private ReadOnlyObjectProperty<Font> headerFont;
    private ReadOnlyObjectProperty<Font> centeredFont;
    private ReadOnlyObjectProperty<Font> paragraphFont;
    @ObjectPropertyType(value=Node.class)
    private ObjectProperty<Node> backButtonNode;
    @ObjectPropertyType(value=Node.class)
    private ObjectProperty<Node> nextButtonNode;
    @ObjectPropertyType(value=EventHandler.class)
    private ObjectProperty<EventHandler<MouseEvent>> firstLastPageAction;
    private boolean withPolygonShading = false;

    private PaginationV2Builder() {
        this.firstLastPageAction(null);
        this.nextButtonNode(null);
        this.backButtonNode(null);
        if (System.getProperty("javafx.polygon.shading") != null) {
            this.withPolygonShading = true;
        }
    }

    public static PaginationV2Builder create() {
        return new PaginationV2Builder();
    }

    public PaginationV2Builder contentMaxWidth(double width) {
        this.contentMaxWidth = new SimpleDoubleProperty((Object)this, "contentMaxWidth", width);
        return this;
    }

    public PaginationV2Builder contentMaxWidth(DoubleProperty width) {
        this.contentMaxWidth = new SimpleDoubleProperty((Object)this, "contentMaxWidth", width.doubleValue());
        return this;
    }

    public PaginationV2Builder contentMaxHeight(double height) {
        this.contentMaxHeight = new SimpleDoubleProperty((Object)this, "contentMaxWidth", height);
        return this;
    }

    public PaginationV2Builder contentMaxHeight(DoubleProperty height) {
        this.contentMaxHeight = new SimpleDoubleProperty((Object)this, "contentMaxHeight", height.doubleValue());
        return this;
    }

    public PaginationV2Builder padding(Insets insets) {
        this.paddingLocal = new ObjectPropertyBase<Insets>(insets){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "paddingLocal";
            }
        };
        return this;
    }

    public PaginationV2Builder backButtonLabel(String backButtonLabel) {
        this.backButtonLabel = new SimpleStringProperty((Object)this, "backButtonLabel", backButtonLabel);
        return this;
    }

    public PaginationV2Builder nextButtonLabel(String nextButtonLabel) {
        this.nextButtonLabel = new SimpleStringProperty((Object)this, "nextButtonLabel", nextButtonLabel);
        return this;
    }

    public PaginationV2Builder text(Text text) {
        this.text = new ObjectPropertyBase<Text>(text){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "text";
            }
        };
        return this;
    }

    public PaginationV2Builder navigationLabelFont(final Font font) {
        this.navigationLabelFont = new ReadOnlyObjectPropertyBase<Font>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "navigationLabelFont";
            }

            public Font get() {
                return font;
            }
        };
        return this;
    }

    public PaginationV2Builder headerFont(final Font font) {
        this.headerFont = new ReadOnlyObjectPropertyBase<Font>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "headerFont";
            }

            public Font get() {
                return font;
            }
        };
        return this;
    }

    public PaginationV2Builder paragraphFont(final Font font) {
        this.paragraphFont = new ReadOnlyObjectPropertyBase<Font>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "paragraphFont";
            }

            public Font get() {
                return font;
            }
        };
        return this;
    }

    public PaginationV2Builder centeredFont(final Font font) {
        this.centeredFont = new ReadOnlyObjectPropertyBase<Font>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "centeredFont";
            }

            public Font get() {
                return font;
            }
        };
        return this;
    }

    public PaginationV2Builder backButtonNode(Node backButtonNode) {
        if (backButtonNode instanceof Polygon && this.withPolygonShading) {
            ((Polygon)backButtonNode).setFill((Paint)Color.DARKGREEN);
            backButtonNode.setOpacity(0.5);
        }
        this.backButtonNode = new SimpleObjectProperty((Object)this, "backButtonNode", (Object)backButtonNode);
        return this;
    }

    public PaginationV2Builder nextButtonNode(Node nextButtonNode) {
        if (nextButtonNode instanceof Polygon && this.withPolygonShading) {
            ((Polygon)nextButtonNode).setFill((Paint)Color.DARKGREEN);
            nextButtonNode.setOpacity(0.5);
        }
        this.nextButtonNode = new SimpleObjectProperty((Object)this, "nextButtonNode", (Object)nextButtonNode);
        return this;
    }

    public PaginationV2Builder firstLastPageAction(EventHandler<MouseEvent> firstLastPageAction) {
        this.firstLastPageAction = new SimpleObjectProperty((Object)this, "firstLastPageEventActionHandler", firstLastPageAction);
        return this;
    }

    public PaginationV2 build() {
        return new PaginationV2(this.backButtonLabel, this.nextButtonLabel, this.backButtonNode, this.nextButtonNode, this.firstLastPageAction, this.text, this.contentMaxWidth, this.contentMaxHeight, this.paddingLocal, this.navigationLabelFont, this.headerFont, this.paragraphFont, this.centeredFont);
    }
}

