/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.io.InputStream;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianSpinnerSkin
extends SkinBase<OpenPatricianSpinner> {
    private final OpenPatricianSpinner spinner;
    private TextSizingUtility sizing = new TextSizingUtility();
    private final TextField textField;
    private ImageView imgViewPlank;
    private final double additionalWidth;

    public OpenPatricianSpinnerSkin(OpenPatricianSpinner spinner) {
        super((Control)spinner);
        this.spinner = spinner;
        String firstValue = "";
        if (!spinner.getOptions().isEmpty()) {
            ObservableList<String> l = spinner.getOptions();
            firstValue = (String)l.get(0);
            spinner.selectedIndexProperty().set(0);
        }
        this.textField = new TextField(firstValue);
        Font font = spinner.getFont();
        spinner.fontProperty().addListener((observalbe, oldValue, newValue) -> this.calculateNewDimension((Font)newValue));
        this.calculateNewDimension(font);
        spinner.optionsProperty().addListener((observable, oldValue, newValue) -> {
            String internalFirst = "";
            if (!spinner.getOptions().isEmpty()) {
                ObservableList<String> l = spinner.getOptions();
                internalFirst = (String)l.get(0);
                spinner.selectedIndexProperty().set(0);
            }
            this.textField.setText(internalFirst);
            this.calculateNewDimension(font);
        });
        HBox hbox = new HBox();
        this.textField.getStyleClass().add((Object)"openPatricianSpinner");
        this.textField.setEditable(false);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("SlabUp.png");
        Image img = new Image(is);
        double imgWidth = img.getWidth();
        ImageView imgViewUp = new ImageView(img);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("SlabDown.png");
        img = new Image(is);
        ImageView imgViewDown = new ImageView(img);
        this.additionalWidth = Math.max(img.getWidth(), imgWidth);
        Group textGroup = new Group(new Node[]{this.textField});
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{imgViewUp, imgViewDown});
        hbox.getChildren().addAll((Object[])new Node[]{textGroup, vbox});
        Group background = new Group(new Node[]{this.imgViewPlank, hbox});
        imgViewUp.setOnMouseReleased(event -> {
            if (this.isNumeticalOptions()) {
                this.selectNextInList(spinner);
            } else {
                this.selectPreviousInList(spinner);
            }
        });
        imgViewDown.setOnMouseReleased(event -> {
            if (this.isNumeticalOptions()) {
                this.selectPreviousInList(spinner);
            } else {
                this.selectNextInList(spinner);
            }
        });
        background.setManaged(false);
        this.getChildren().add((Object)background);
    }

    private boolean isNumeticalOptions() {
        String str = (String)this.spinner.getOptions().get(0);
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private void selectPreviousInList(OpenPatricianSpinner spinner) {
        ObservableList<String> options1 = spinner.getOptions();
        if (!options1.isEmpty() && spinner.getSelectedIndex() > 0) {
            spinner.decSelectedIndex();
            String newDisplayValue = (String)options1.get(spinner.getSelectedIndex());
            this.textField.setText(newDisplayValue);
        }
    }

    private void selectNextInList(OpenPatricianSpinner spinner) {
        ObservableList<String> options1 = spinner.getOptions();
        if (!options1.isEmpty() && spinner.getSelectedIndex() < options1.size()) {
            spinner.incSelectedIndex();
            String newDisplayValue = (String)options1.get(spinner.getSelectedIndex());
            this.textField.setText(newDisplayValue);
        }
    }

    private void calculateNewDimension(Font font) {
        double width = 10.0;
        ObservableList<String> options = this.spinner.getOptions();
        Dimension2D dim4heigth = this.sizing.calculate(1, font);
        for (String word : options) {
            Dimension2D dim4width = this.sizing.calculate(word, font);
            if (!(dim4width.getWidth() > width)) continue;
            width = dim4width.getWidth() + 10.0 + 20.0;
        }
        double maxWidth = this.spinner.getMaxWidth();
        Dimension2D dim = new Dimension2D(Math.max(width, maxWidth), dim4heigth.getHeight());
        this.textField.setMinWidth(dim.getWidth());
        this.textField.setMaxSize(dim.getWidth(), dim.getHeight());
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("InputPlank.jpg");
        Image img = new Image(is, dim.getWidth() + this.additionalWidth, dim.getHeight(), false, true);
        if (this.imgViewPlank == null) {
            this.imgViewPlank = new ImageView(img);
        } else {
            this.imgViewPlank.setImage(img);
        }
    }
}

