/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.io.InputStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianWoodenTextInputSkin
extends SkinBase<OpenPatricianWoodenTextInput> {
    private DoubleProperty width = new SimpleDoubleProperty((Object)this, "width", 0.0);
    private DoubleProperty height = new SimpleDoubleProperty((Object)this, "height", 0.0);
    private TextSizingUtility sizing = new TextSizingUtility();
    private final TextField textField;
    private final ImageView imgView;

    public OpenPatricianWoodenTextInputSkin(OpenPatricianWoodenTextInput input) {
        super((Control)input);
        this.textField = new TextField(input.getText());
        this.imgView = new ImageView();
        this.calculateDimensions(input);
        this.textField.textProperty().bindBidirectional((Property)input.textProperty());
        this.textField.getStyleClass().add((Object)"openPatricianWoodenTextInput");
        Insets padding = this.textField.getPadding();
        Insets newPadding = new Insets(0.0, padding.getRight(), 0.0, padding.getLeft());
        this.textField.setPadding(newPadding);
        input.sizeProperty().addListener((observable, oldValue, newValue) -> {
            this.calculateDimensions(input);
            System.out.println("Changed size: " + oldValue + " -> " + newValue);
        });
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{this.imgView, this.textField});
        Group group = new Group(new Node[]{stack});
        group.setManaged(false);
        this.getChildren().add((Object)group);
    }

    private void calculateDimensions(OpenPatricianWoodenTextInput input) {
        Dimension2D dim = this.sizing.calculate(input.getSize(), input.getFont());
        this.width.set(dim.getWidth());
        this.height.set(dim.getHeight());
        this.textField.setMaxSize(this.width.doubleValue(), this.height.doubleValue());
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("InputPlank.jpg");
        Image img1 = new Image(is, this.width.doubleValue(), this.height.doubleValue(), false, true);
        this.imgView.setImage(img1);
    }
}

