/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.model;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

@ClassCategory(value={EClassCategory.MODEL})
public class NoticeBoardMenuEntry {
    private DecoratedText label;
    private NoticeBoardMenu menu;
    private BooleanProperty disabled = new SimpleBooleanProperty(false);
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    private int inset = 0;
    private EventHandler<MouseEvent> onMouseSelect;
    private final EDialogType dialogType;

    public NoticeBoardMenuEntry(EDialogType dialogType) {
        this.dialogType = dialogType;
    }

    public boolean getDisabled() {
        return this.disabled.get();
    }

    public BooleanProperty disabledProperty() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled);
    }

    public boolean getSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public void setLabel(DecoratedText label) {
        this.label = label;
        this.label.setLayoutX(this.inset);
        label.setOnMouseReleased(evt -> {
            if (!this.getDisabled()) {
                this.menu.deselctAll();
                this.selected.setValue(Boolean.valueOf(true));
                this.onMouseSelect.handle(evt);
            }
        });
    }

    public DecoratedText getLabel() {
        return this.label;
    }

    public void setMenu(NoticeBoardMenu menu) {
        this.menu = menu;
    }

    public NoticeBoardMenu getMenu() {
        return this.menu;
    }

    public void setInset(int inset) {
        this.inset = inset;
    }

    public EventHandler<MouseEvent> getOnMouseSelect() {
        return this.onMouseSelect;
    }

    public void setOnMouseSelect(EventHandler<MouseEvent> onMouseSelect) {
        this.onMouseSelect = onMouseSelect;
    }

    public EDialogType getDialogType() {
        return this.dialogType;
    }
}

