/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenu;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.NoticeBoardChurchMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardCityHallMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardLoanerMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardMarketPlaceMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardMenuTitleProvider;
import ch.sahits.game.javafx.service.NoticeBoardMessageMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardShipyardMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardTavernMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardTradingMenuProvider;
import ch.sahits.game.javafx.service.NoticeBoardTradingOfficeMenuProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardMenuProvider {
    @Autowired
    private NoticeBoardMenuTitleProvider titleProvider;
    @Autowired
    private NoticeBoardMessageMenuProvider messageProvider;
    @Autowired
    private NoticeBoardChurchMenuProvider churchMenuProvider;
    @Autowired
    private NoticeBoardCityHallMenuProvider cityHallMenuProvider;
    @Autowired
    private NoticeBoardMarketPlaceMenuProvider marketPlaceMenuProvider;
    @Autowired
    private NoticeBoardTradingOfficeMenuProvider tradingOfficeMenuProvider;
    @Autowired
    private NoticeBoardTradingMenuProvider tradingMenuProvider;
    @Autowired
    private NoticeBoardTavernMenuProvider tavernMenuProvider;
    @Autowired
    private NoticeBoardLoanerMenuProvider loanerMenuProvider;
    @Autowired
    private NoticeBoardShipSelectionMenuProvider shipSelectionMenuProvider;
    @Autowired
    private NoticeBoardShipyardMenuProvider shipyardMenuProvider;

    public NoticeBoardMenu createMenu(ENoticeBoardType type, ICityPlayerProxyJFX proxy) {
        NoticeBoardMenu menu = new NoticeBoardMenu(type);
        menu.setTitle(this.titleProvider.createTitle(type));
        LinkedHashSet<NoticeBoardMenuEntry> entries = null;
        switch (type) {
            case MESSAGE: {
                entries = this.messageProvider.createMenuEntries(proxy, type);
                break;
            }
            case CHURCH: {
                entries = this.churchMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case CITY_HALL_ALDERMAN_OFFICE: 
            case CITY_HALL_MAYORS_OFFICE: 
            case CITY_HALL_MEETINGROOM: 
            case CITY_HALL_NOTICE_BOARD: {
                entries = this.cityHallMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case LOANER: {
                entries = this.loanerMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case MARKET_PLACE: {
                entries = this.marketPlaceMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case SHIP_SELECTION: {
                entries = this.shipSelectionMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case SHIPYARD: {
                entries = this.shipyardMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case TAVERN: {
                entries = this.tavernMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case TRADING: {
                entries = this.tradingMenuProvider.createMenuEntries(proxy, type);
                break;
            }
            case TRADING_OFFICE: {
                entries = this.tradingOfficeMenuProvider.createMenuEntries(proxy, type);
            }
        }
        menu.setMenuEntries(entries);
        for (NoticeBoardMenuEntry entry : entries) {
            entry.setMenu(menu);
        }
        return menu;
    }
}

