/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.model.DisplayMessages;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.javafx.service.TextEllipsisCalculator;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardMessageMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private DisplayMessages displayMessages;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TextEllipsisCalculator ellipsisCalculator;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private ApplicationContext context;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        ObservableList<DisplayMessage> messages = this.displayMessages.messagesProperty();
        double maxWidth = 186.0;
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        for (DisplayMessage message : messages) {
            Object[] args = message.getMessageArguments();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof EWare)) continue;
                args[i] = this.translator.getLocalDisplayName((EWare)args[i]);
            }
            String translatedMessage = this.messageSource.getMessage(message.getMessageKey(), args, this.locale.getCurrentLocal());
            DecoratedText text = new DecoratedText();
            String messageString = this.ellipsisCalculator.calculateEllipsis(text.getFont(), translatedMessage, maxWidth);
            text = this.textFactory.createSimpleDecoratedText(messageString);
            EventHandler<MouseEvent> onMouseFocus = this.getDisplaMessageMouseEnterFocusEventHandler(text, translatedMessage);
            EventHandler<MouseEvent> onMouseExitFocus = this.getDisplayMessageMouseExitFocusEventHandler(text);
            text.setOnMouseEntered(onMouseFocus);
            text.setOnMouseExited(onMouseExitFocus);
            NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(null);
            entry.setLabel(text);
            if (message.hasDialogTemplate()) {
                args = new Object[]{message.getDialogTemplate()};
                Runnable runnable = (Runnable)this.context.getBean("viewChangeDialogTemplateRunnable", args);
                EventHandler openDialogEvenHandler = evt -> runnable.run();
                entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogEvenHandler);
            }
            entries.add(entry);
        }
        return entries;
    }

    private EventHandler<MouseEvent> getDisplaMessageMouseEnterFocusEventHandler(DecoratedText text, String message) {
        return event -> {
            Group viewContainer = (Group)((StackPane)text.getScene().getRoot()).getChildren().get(1);
            DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(message, this.sizeing);
            double y = event.getSceneY();
            label.setLayoutY(y);
            label.setLayoutX(350.0);
            viewContainer.getChildren().add((Object)label);
        };
    }

    private EventHandler<MouseEvent> getDisplayMessageMouseExitFocusEventHandler(DecoratedText text) {
        return event -> {
            Group viewContainer = (Group)((StackPane)text.getScene().getRoot()).getChildren().get(1);
            Iterator iterator = viewContainer.getChildren().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof DisplayMessageOverlayLabel)) continue;
                iterator.remove();
                break;
            }
        };
    }
}

