/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.event.WrappedDialogType;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.service.ShipService;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardShipSelectionMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ShipService shipService;
    @Autowired
    protected DecoratedTextFactory textFactory;
    @Autowired
    private ApplicationContext context;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        ObservableList vessels = proxy.getPlayersNavalVessels();
        for (INavigableVessel vessel : vessels) {
            NoticeBoardMenuEntry entry;
            String key;
            int weaponsStrength = this.shipService.calculateShipsWeaponsStrength(vessel);
            if (vessel instanceof IShip) {
                Object[] args = new Object[]{EDialogType.SHIP_CONVOY};
                Runnable runnable1 = (Runnable)this.context.getBean("viewChangeActionRunnable", args);
                EventHandler openDialogEvenHandler = evt -> {
                    proxy.activateShip(vessel);
                    if (!evt.getButton().equals((Object)MouseButton.PRIMARY)) {
                        runnable1.run();
                    }
                };
                boolean disabled = false;
                String key2 = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship";
                NoticeBoardMenuEntry entry2 = this.createNoticeBoardEntry(proxy, vessel, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship", false);
                entry2.setOnMouseSelect((EventHandler<MouseEvent>)openDialogEvenHandler);
                entries.add(entry2);
                continue;
            }
            IConvoy convoy = (IConvoy)vessel;
            boolean disabled = !convoy.getOwner().equals(proxy.getPlayer());
            Object[] args = new Object[]{EDialogType.SHIP_CONVOY};
            Runnable runnable1 = (Runnable)this.context.getBean("viewChangeActionRunnable", args);
            EventHandler openDialogConvoyEvenHandler = evt -> {
                proxy.activateShip(vessel);
                if (!evt.getButton().equals((Object)MouseButton.PRIMARY)) {
                    runnable1.run();
                }
            };
            if (weaponsStrength < 5) {
                key = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.smallstrangth.capacity";
                entry = this.createNoticeBoardEntry(proxy, (INavigableVessel)convoy, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.smallstrangth.capacity", false);
                entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogConvoyEvenHandler);
                entries.add(entry);
            } else {
                key = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.bigstrangth.capacity";
                entry = this.createNoticeBoardEntry(proxy, (INavigableVessel)convoy, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.bigstrangth.capacity", false);
                entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogConvoyEvenHandler);
                entries.add(entry);
            }
            List convoyMembers = convoy.getShips();
            for (IShip convoyMember : convoyMembers) {
                disabled = !convoyMember.getOwner().equals(proxy.getPlayer());
                String key3 = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.shipinconvoy";
                NoticeBoardMenuEntry entry3 = this.createNoticeBoardEntry(proxy, (INavigableVessel)convoyMember, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.shipinconvoy", true);
                if (!convoyMember.equals(convoy.getOrlegShip())) {
                    WrappedDialogType wrapper = new WrappedDialogType(EDialogType.LEAVE_CONVOY, convoy, convoyMember);
                    Runnable run = (Runnable)this.context.getBean("viewChangeWrappedRunnable", new Object[]{wrapper});
                    entry3.setOnMouseSelect((EventHandler<MouseEvent>)((EventHandler)event -> {
                        proxy.activateShip(vessel);
                        if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                            run.run();
                        }
                    }));
                } else {
                    entry3.setOnMouseSelect((EventHandler<MouseEvent>)((EventHandler)evt -> proxy.activateShip(vessel)));
                }
                entries.add(entry3);
            }
        }
        return entries;
    }

    private NoticeBoardMenuEntry createNoticeBoardEntry(ICityPlayerProxyJFX proxy, INavigableVessel vessel, boolean disabled, String key, boolean inset) {
        String loadedText = this.messageSource.getMessage(key, new Object[]{vessel.getName(), vessel.getCapacity()}, this.locale.getCurrentLocal());
        return this.createMenuEntry(proxy, vessel, loadedText, disabled);
    }

    private NoticeBoardMenuEntry createMenuEntry(ICityPlayerProxyJFX proxy, INavigableVessel vessel, String loadedText, boolean disabled) {
        DecoratedText dt = this.textFactory.createDecoratedText(loadedText, new HashMap<String, Object>());
        NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(null);
        entry.setLabel(dt);
        entry.setDisabled(disabled);
        entry.setSelected(vessel.equals(proxy.getActiveShip()));
        return entry;
    }
}

