/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISailors;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardTavernMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private CaptainsState captainsState;
    @Autowired
    private CitiesState cityState;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        TavernState tavernState = this.getTavernState(proxy.getCity());
        Optional captain = this.captainsState.getCaptain(proxy.getCity());
        ObservableList present = tavernState.presentPersonsProperty();
        ArrayList sideRoom = Lists.newArrayList();
        ArrayList mainRoom = Lists.newArrayList();
        IHumanPlayer player = proxy.getPlayer();
        this.collectPresentPersons(tavernState, (List<IPerson>)present, sideRoom, mainRoom, (IPlayer)player);
        if (captain.isPresent()) {
            mainRoom.add(captain.get());
        }
        for (IPerson pers : mainRoom) {
            String s = this.messageSource.getMessage(pers.getClass().getName() + ".noticeboardTitle", new Object[0], this.locale.getCurrentLocal());
            NoticeBoardMenuEntry entry = this.createNoticeBoardEntryMainRoom(s, pers, tavernState, (IPlayer)player);
            entries.add(entry);
        }
        if (!sideRoom.isEmpty()) {
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.sideRoom", new Object[0], this.locale.getCurrentLocal());
            NoticeBoardMenuEntry entry = this.createNoticeBoardEntrySideRoom(s, (IPerson)sideRoom.get(0), tavernState, (IPlayer)player);
            entries.add(entry);
        }
        return entries;
    }

    @VisibleForTesting
    void collectPresentPersons(TavernState tavernState, List<IPerson> present, List<ISideRoomPerson> sideRoom, List<IPerson> mainRoom, IPlayer player) {
        for (IPerson pers : present) {
            if (pers instanceof ISideRoomPerson) {
                if (tavernState.isTalkingToOtherPlayer((ITavernPerson)((ISideRoomPerson)pers), player) || (pers instanceof ITreasureMapOwner || pers instanceof IPirateHunter) && player.getSegmentedMap() != null) continue;
                sideRoom.add((ISideRoomPerson)pers);
                continue;
            }
            mainRoom.add(pers);
        }
    }

    private TavernState getTavernState(ICity city) {
        for (CityState state : this.cityState.getCityEngineStates()) {
            if (!state.getCity().equals(city)) continue;
            return state.getTavernState();
        }
        return null;
    }

    private NoticeBoardMenuEntry createNoticeBoardEntryMainRoom(String s, IPerson showingPerson, TavernState tavernState, IPlayer currentPlayer) {
        DecoratedText label = this.textFactory.createSimpleDecoratedText(s);
        EDialogType dialogType = this.getDialogTypeMainRoom(showingPerson);
        NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(dialogType);
        entry.setLabel(label);
        Object[] args = new Object[]{showingPerson, tavernState, currentPlayer, dialogType};
        Runnable runnable1 = (Runnable)this.context.getBean("tavernDialogChangeAction", args);
        EventHandler openDialogEvenHandler = evt -> runnable1.run();
        entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogEvenHandler);
        return entry;
    }

    private NoticeBoardMenuEntry createNoticeBoardEntrySideRoom(String s, IPerson showingPerson, TavernState tavernState, IPlayer player) {
        DecoratedText label = this.textFactory.createSimpleDecoratedText(s);
        NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(EDialogType.TAVERN_SIDE_ROOM);
        entry.setLabel(label);
        Object[] args = new Object[]{showingPerson, tavernState, player};
        Runnable runnable1 = (Runnable)this.context.getBean("tavernDialogTalkToSideroomPersonAction", args);
        EventHandler openDialogEvenHandler = evt -> runnable1.run();
        entry.setOnMouseSelect((EventHandler<MouseEvent>)openDialogEvenHandler);
        return entry;
    }

    private EDialogType getDialogTypeMainRoom(IPerson showingPerson) {
        EDialogType selected = null;
        if (showingPerson instanceof IBuyer) {
            selected = EDialogType.TAVERN_BUYER;
        }
        if (showingPerson instanceof ISailors) {
            selected = EDialogType.TAVERN_SAILORS;
        }
        if (showingPerson instanceof IWeaponsDealer) {
            selected = EDialogType.TAVERN_WEAPONS_DEALER;
        }
        if (showingPerson instanceof IInformant) {
            selected = EDialogType.TAVERN_INFORMANT_1;
        }
        if (showingPerson instanceof ICaptain) {
            selected = EDialogType.TAVERN_CAPTAIN;
        }
        if (showingPerson instanceof IPirate) {
            selected = EDialogType.TAVERN_PIRATE;
        }
        if (showingPerson instanceof ITraveler) {
            selected = EDialogType.TAVERN_TRAVELER;
        }
        if (showingPerson instanceof ITrader) {
            selected = EDialogType.TAVERN_TRADER;
        }
        return selected;
    }
}

