package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import javafx.geometry.Dimension2D;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
/**
 * Utility class to define the dimensions of texts used with a certain font.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Aug 4, 2013
 *
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class TextSizingUtility {

    double computeTextWidth(Font font, String text, double wrappingWidth) {
        Text helper = new Text();
        helper.setFont(font);
        helper.setText(text);
        // Note that the wrapping width needs to be set to zero before
        // getting the text's real preferred width.
        helper.setWrappingWidth(0);
        helper.setLineSpacing(0);
        double w = Math.min(helper.prefWidth(-1), wrappingWidth);
        helper.setWrappingWidth((int)Math.ceil(w));
        double textWidth = Math.ceil(helper.getLayoutBounds().getWidth());
		return textWidth;
    }

    double computeTextHeight(Font font, String text, double wrappingWidth) {
        return computeTextHeight(font, text, wrappingWidth, 0);
    }

    double computeTextHeight(Font font, String text, double wrappingWidth, double lineSpacing) {
        Text helper = new Text();
        helper.setFont(font);
        helper.setText(text);
        helper.setWrappingWidth((int)wrappingWidth);
        helper.setLineSpacing(lineSpacing);
        return helper.getLayoutBounds().getHeight();
    }
    /**
     * Calculate the dimensions of a string using the font with the number of characters.
     * The height is the maximum value, the width is an average value.
     * @param size
     * @param font
     * @return
     */
	public Dimension2D calculate(int size, Font font) {
		double height = computeTextHeight(font, "Tg", Double.MAX_VALUE);
		double width = computeTextWidth(font, "n", Double.MAX_VALUE);
		Dimension2D dim = new Dimension2D(width*size*.8, height*1.2);
		return dim;
	}

    /**
     * Guess the number of characters that can be displayed in <code>destWidth</code>.
     * The number is guessed as an arbitrary width per character for the font is assumed.
     * @param destWidth
     * @param font
     * @return
     */
    public int guessNumberOfCharacters(double destWidth, Font font) {
        double width = computeTextWidth(font, "n", Double.MAX_VALUE);
        return (int) Math.floor(destWidth/(width*0.8));
    }
    /**
     * Calculate the dimensions of a string using the font with the number of characters.
     * The height is the maximum value, the width is an average value. The text will not be wrapped.
     * @param text
     * @param font
     * @return
     */
	public Dimension2D calculate(String text, Font font) {
		double height = computeTextHeight(font, text, Double.MAX_VALUE);
		double width = computeTextWidth(font, text, Double.MAX_VALUE);
		Dimension2D dim = new Dimension2D(width, height*1.2);
		return dim;
	}

}