package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

import java.io.InputStream;

/**
 * Skin class for the open patrician wood input.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianWoodenTextInputSkin extends SkinBase<OpenPatricianWoodenTextInput> {
	
	private DoubleProperty width = new SimpleDoubleProperty(this, "width", 0);
	private DoubleProperty height = new SimpleDoubleProperty(this, "height", 0);

	private TextSizingUtility sizing = new TextSizingUtility();
	private final TextField textField;
    private final ImageView imgView;

    public OpenPatricianWoodenTextInputSkin(OpenPatricianWoodenTextInput input) {
		super(input);

		textField = new TextField(input.getText());
        imgView = new ImageView();

        calculateDimensions(input);

		textField.textProperty().bindBidirectional(input.textProperty());
		textField.getStyleClass().add("openPatricianWoodenTextInput");
        Insets padding = textField.getPadding();
        Insets newPadding = new Insets(0, padding.getRight(), 0, padding.getLeft());
        textField.setPadding(newPadding);

		// Listeners
		input.sizeProperty().addListener((observable, oldValue, newValue) -> {
            calculateDimensions(input);
            System.out.println("Changed size: "+oldValue+" -> "+newValue);
        });
		
		
		StackPane stack = new StackPane();
		stack.getChildren().addAll(imgView, textField);
		Group group = new Group(stack);
		group.setManaged(false);
		
		getChildren().add(group);
	}

	private void calculateDimensions(OpenPatricianWoodenTextInput input) {
		Dimension2D dim = sizing.calculate(input.getSize(), input.getFont());
		width.set(dim.getWidth());
		height.set(dim.getHeight());
		textField.setMaxSize(width.doubleValue(), height.doubleValue());
        final InputStream is = getClass().getResourceAsStream("InputPlank.jpg");
        Image img1 = new Image(is,width.doubleValue(), height.doubleValue(), false, true);
        imgView.setImage(img1);
    }


}
