package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.PlaceHolder;
import javafx.scene.Group;
import javafx.scene.control.SkinBase;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

/**
 * Skin defining the makeup of the PlaceHolder.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 1, 2013
 *
 */
public class PlaceHolderSkin  extends SkinBase<PlaceHolder> {

	public PlaceHolderSkin(PlaceHolder control) {
		super(control);
		Rectangle area = new Rectangle(control.getX(), control.getY(), control.getLocalWidth(), control.getLocalHeight());
		area.setFill(Color.TRANSPARENT);
		area.xProperty().bind(control.xProperty());
		area.yProperty().bind(control.yProperty());
		area.widthProperty().bind(control.widthLocalProperty());
		area.heightProperty().bind(control.heightLocalProperty());
		Group g = new Group(area);
		
		getChildren().add(g);
	}

}
