package ch.sahits.game.javafx.event;


import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
/**
 * Event handler that closes the application on the key combination Ctrl+Q
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jul 21, 2013
 *
 */
@ClassCategory(EClassCategory.HANDLER)
public class CloseApplicationEventHandler implements EventHandler<KeyEvent> {

	@Override
	public void handle(KeyEvent event) {
		if (event.getCode().equals(KeyCode.Q) && event.isControlDown()) {
			event.consume();
			Platform.exit();
		}
		
	}


}
