package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * This container holds at max 50 DisplayMessages. The new ones are inserted at index 0.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Mar 04, 2015
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN,EClassCategory.SINGLETON_BEAN})
public class DisplayMessages {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(getClass());
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier("serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    @ListType(DisplayMessage.class)
    private SimpleListProperty<DisplayMessage> messages = new SimpleListProperty<>();

    public DisplayMessages() {
        messages.set(FXCollections.observableArrayList());
    }
    @PostConstruct
    private void init() {
        clientEventBus.register(this);
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        clientEventBus.unregister(this);
        clientServerEventBus.unregister(this);
    }


    public boolean add(DisplayMessage element) {
        if (messages.size()==50) {
            messages.remove(50);
        }
        messages.add(0, element);
        return true;
    }
    @Subscribe
    public void handleMessage(DisplayMessage message) {
        add(message);
    }

    public ObservableList<DisplayMessage> messagesProperty() {
        return messages;
    }
}
