package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;
import java.util.TreeSet;

/**
 * Provide menu items for the city hall notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardCityHallMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();
        String s;
        switch (type) {
            case CITY_HALL_ALDERMAN_OFFICE:
                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.hanseaticInfo", new Object[]{}, locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_HANSEATIC_INFO);
                entries.add(entry);
                if (proxy.getPlayer().getRank() == ESocialRank.ALDERMAN && proxy.getPlayer().getHometown().equals(proxy.getCity())) { // FIXME: 12/19/15 this only works if the player is alderman, cannot open if anyone else is alderman
                    s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.aldermanOffice", new Object[]{}, locale.getCurrentLocal());
                    entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_ALDERMAN_OFFICE);
                    entries.add(entry);
                }
                break;
            case CITY_HALL_MEETINGROOM:
                s = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.meetings", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_MEETING_ROOM);
                entry.setSelected(true);
                entries.add(entry);
                break;
            case CITY_HALL_MAYORS_OFFICE:
                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.townInfo", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_TOWN_INFO);
                entries.add(entry);

                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.treasury", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_TREASURY);
                entries.add(entry);
                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityWall", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_CITY_WALL);
                entries.add(entry);
                break;
            case CITY_HALL_NOTICE_BOARD:
                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallPublicNotice", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_NOTICE);
                entries.add(entry);
                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallOutriggerNotice", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.CITY_HALL_OUTRIGGER);
                entries.add(entry);
                break;
        }
        return entries;
    }
}
