package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;

/**
 * Provide menu items for the market place notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardMarketPlaceMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();
        String s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.stockPrices", new Object[]{}, locale.getCurrentLocal());
        NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.MB_STOCK_PRICES);
        entries.add(entry);

        s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.consumptionProduction", new Object[]{}, locale.getCurrentLocal());
        entry = createNoticeBoardEntry(s, EDialogType.MB_CONSUMPTION_PRODUCTION);
        entries.add(entry);

        return entries;
    }
}
