/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.NoticeBoardCityHallMenuProvider;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.LinkedHashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardCityHallMenuProviderTest {
    @Mock
    private Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private ApplicationContext context;
    @Mock
    private DecoratedTextFactory textFactory;
    @InjectMocks
    private NoticeBoardCityHallMenuProvider menuProvider;

    @Test
    public void shouldProvideThreeMenuItemsMayorsOffice() {
        ICityPlayerProxyJFX mock = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(mock, ENoticeBoardType.CITY_HALL_MAYORS_OFFICE);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)3))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)3))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_TOWN_INFO});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_TREASURY});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_CITY_WALL});
        Assert.assertEquals((long)3L, (long)entries.size());
    }

    @Test
    public void shouldProvideTwoMenuItemsNoticeBoard() {
        ICityPlayerProxyJFX mock = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(mock, ENoticeBoardType.CITY_HALL_NOTICE_BOARD);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)2))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)2))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_NOTICE});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_OUTRIGGER});
        Assert.assertEquals((long)2L, (long)entries.size());
    }

    @Test
    public void shouldProvideOneMenuItemsMeetingRoom() {
        ICityPlayerProxyJFX mock = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(mock, ENoticeBoardType.CITY_HALL_MEETINGROOM);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)1))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_MEETING_ROOM});
        Assert.assertEquals((long)1L, (long)entries.size());
    }

    @Test
    public void shouldProvideOneMenuItemsAldermanOfficeInDifferentTown() {
        ICityPlayerProxyJFX mock = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)player.getRank()).willReturn((Object)ESocialRank.ALDERMAN);
        ICity thisCity = (ICity)Mockito.mock(ICity.class);
        ICity hometown = (ICity)Mockito.mock(ICity.class);
        BDDMockito.given((Object)player.getHometown()).willReturn((Object)hometown);
        BDDMockito.given((Object)mock.getCity()).willReturn((Object)thisCity);
        BDDMockito.given((Object)mock.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(mock, ENoticeBoardType.CITY_HALL_ALDERMAN_OFFICE);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)1))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_HANSEATIC_INFO});
        Assert.assertEquals((long)1L, (long)entries.size());
    }

    @Test
    public void shouldProvideTwoMenuItemsAldermanOffice() {
        ICityPlayerProxyJFX mock = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)player.getRank()).willReturn((Object)ESocialRank.ALDERMAN);
        ICity thisCity = (ICity)Mockito.mock(ICity.class);
        BDDMockito.given((Object)player.getHometown()).willReturn((Object)thisCity);
        BDDMockito.given((Object)mock.getCity()).willReturn((Object)thisCity);
        BDDMockito.given((Object)mock.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(mock, ENoticeBoardType.CITY_HALL_ALDERMAN_OFFICE);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)2))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)2))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_HANSEATIC_INFO});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CITY_HALL_ALDERMAN_OFFICE});
        Assert.assertEquals((long)2L, (long)entries.size());
    }
}

