/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.NoticeBoardTradingMenuProvider;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardTradingMenuProviderTest {
    @Mock
    private Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private ApplicationContext context;
    @Mock
    private DecoratedTextFactory textFactory;
    @InjectMocks
    private NoticeBoardTradingMenuProvider menuProvider;

    @Test
    public void shouldProvideFourMenuItems() {
        ICity city = (ICity)Mockito.mock(ICity.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        ITradingOffice tradingOffice = (ITradingOffice)Mockito.mock(ITradingOffice.class);
        ArrayList<ITradingOffice> offices = new ArrayList<ITradingOffice>();
        offices.add(tradingOffice);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        BDDMockito.given((Object)proxy.getCity()).willReturn((Object)city);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)city.findBuilding(ITradingOffice.class, Optional.of(player))).willReturn(offices);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(proxy, null);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)4))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)4))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.PORT_CITY_TO_SHIP});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.PORT_CITY_TO_STORAGE});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.PORT_STORAGE_TO_SHIP});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.PORT_WEAPON});
        Assert.assertEquals((long)4L, (long)entries.size());
    }

    @Test
    public void shouldProvideMenuItemsWhenThereIsNoTradingOffice() {
        ICity city = (ICity)Mockito.mock(ICity.class);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        ArrayList offices = new ArrayList();
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        BDDMockito.given((Object)proxy.getCity()).willReturn((Object)city);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        BDDMockito.given((Object)city.findBuilding(ITradingOffice.class, Optional.of(player))).willReturn(offices);
        LinkedHashSet entries = this.menuProvider.createMenuEntries(proxy, null);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)1))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.PORT_CITY_TO_SHIP});
        Assert.assertEquals((long)1L, (long)entries.size());
    }
}

