package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.bindings.StringToIntegerBinding;
import ch.sahits.game.javafx.bindings.ZeroAmountBooleanBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(EClassCategory.JAVAFX)
public class BarrelAmount extends BarrelAmountAlwaysVisible {

	public BarrelAmount() {
        super();
		IntegerProperty intAmount = new SimpleIntegerProperty();
		intAmount.bind(new StringToIntegerBinding(amountProperty()));
		visibleProperty().bind(new ZeroAmountBooleanBinding(intAmount));
	}
}
