package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
/**
 * Control representing the main menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class SubMenu extends Group {

	public SubMenu() {
		setManaged(false);
		Rectangle placeHolder = new Rectangle(0, 0, 250, 50);
		placeHolder.setFill(Color.GREEN);
		placeHolder.setOpacity(0.25);
		Text lbl = new Text("SubMenu") ;
		lbl.setLayoutX(5);
		lbl.setLayoutY(placeHolder.getHeight()/2);
		getChildren().addAll(placeHolder, lbl);
	}
}
