package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import javafx.geometry.Point2D;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.LinkedList;
import java.util.List;

/**
 * A Bèzier path is made up by consecutive Bèzier curves.
 * This model class is intended for use with CurveTo, as it contains
 * a list of BezierCurveControls that define the curve.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 06, 2016
 */
@RequiredArgsConstructor
@ClassCategory(EClassCategory.MODEL)
public class BezierPath {
    @Getter
    private final Point2D startpoint;
    @Getter
    @ListType(BezierCurveControls.class)
    private final List<BezierCurveControls> bezierCurves = new LinkedList<>();

    public void addSegment(BezierCurveControls segment) {
        bezierCurves.add(segment);
    }
}
