package ch.sahits.game.openpatrician.dialog;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

/**
 * Base class for Open Patrician dialogs.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 14, 2013
 *
 */
@ClassCategory({EClassCategory.JAVAFX})
public class Dialog extends Group implements IDialog{
	@Autowired
	protected DecoratedTextFactory decoratedTextFactory;
	private final Group content;
	@Getter
	@Setter
	private EDialogType dialogType;
	
	public Dialog() {
		setManaged(false);
        getStylesheets().add(Dialog.class.getResource("Dialog.css").toExternalForm());
		InputStream is = Dialog.class.getResourceAsStream("fringe.jpg");
		Image img = new Image(is);
		ImageView imgView = new ImageView(img);
		content = new Group();
		getChildren().addAll(imgView, content);
	}
	

	public ObservableList<Node> getContent() {
		return content.getChildren();
	}

	public void replaceContent(Node... nodes){
		replaceContent(Arrays.asList(nodes));
	}
	public void replaceContent(List<Node> nodes){
		content.getChildren().clear();
		content.getChildren().addAll(nodes);
	}

	/**
	 * Subclasses should override this method to ensure that the dialog properly cleans up
	 * the state before it is closed.
	 */
	public void close() {}
}
