/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.BaleAmount;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.CoinPrice;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.test.JavaFXThreadingRule;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.util.ReflectionUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class DecoratedTextFactoryTest {
    @Rule
    public JavaFXThreadingRule javafxRule = new JavaFXThreadingRule();
    private DecoratedTextFactory factory;
    @Mock
    private XMLImageLoader imageLoader;
    @Mock
    private IFontLoader fontLoader;

    @Before
    public void setUp() {
        this.factory = new DecoratedTextFactory(42, 47, 4711);
        BDDMockito.given((Object)this.fontLoader.createDefaultFont(18)).willReturn((Object)Font.font((double)18.0));
        Field field = ReflectionUtils.findField(this.factory.getClass(), (String)"imageLoader");
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)this.factory, (Object)this.imageLoader);
        field = ReflectionUtils.findField(this.factory.getClass(), (String)"fontLoader");
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)this.factory, (Object)this.fontLoader);
        InputStream is = this.getClass().getResourceAsStream("/images/MapSegment1.png");
        Image img = new Image(is);
        BDDMockito.given((Object)this.imageLoader.getImage("images/MapSegment1")).willReturn((Object)img);
        is = this.getClass().getResourceAsStream("/icons/64/cannonballs_icon.png");
        img = new Image(is);
        BDDMockito.given((Object)this.imageLoader.getImage("icons/64/cannonballs_icon")).willReturn((Object)img);
    }

    @Test
    public void shouldInitializeDecoratedTextProperties() {
        DecoratedText result = this.factory.createDecoratedText("", null);
        TestCase.assertEquals((Object)result.getLayoutX(), (Object)42.0);
        TestCase.assertEquals((Object)result.getLayoutY(), (Object)47.0);
        TestCase.assertEquals((int)result.getWrappingWidth(), (int)4711);
    }

    @Test
    public void shouldSetSimpleText() {
        String s = "The fox jumps over the lazy dog\n";
        DecoratedText result = this.factory.createDecoratedText(s, null);
        TestCase.assertTrue((boolean)(result.getChildren().get(0) instanceof Text));
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)s);
    }

    @Test(expected=RuntimeException.class)
    public void shouldFailOnParameterRetrivingWithNullMap() {
        String s = "The fox jumps over the lazy dog [dogName]\n";
        DecoratedText result = this.factory.createDecoratedText(s, null);
    }

    @Test(expected=RuntimeException.class)
    public void shouldFailOnParameterRetrivingWithMissingParameter() {
        String s = "The fox jumps over the lazy dog [dogName]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("catName", "Pussy");
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
    }

    @Test
    public void shouldReplaceSimpleParameterParameter() {
        String s = "The fox jumps over the lazy dog [dogName]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"The fox jumps over the lazy dog Max\n");
    }

    @Test
    public void shouldReplaceTwoSimpleParameterParameter() {
        String s = "pre [foxName] inter [dogName]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        parameters.put("foxName", "Gustav");
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        text = (Text)result.getChildren().get(1);
        TestCase.assertEquals((String)text.getText(), (String)"Gustav ");
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"inter Max\n");
    }

    @Test
    public void shouldReplaceRepeatedSimpleParameterParameter() {
        String s = "pre [dogName] inter [dogName]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        parameters.put("foxName", "Gustav");
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        text = (Text)result.getChildren().get(1);
        TestCase.assertEquals((String)text.getText(), (String)"Max ");
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"inter Max\n");
    }

    @Test
    public void shouldReplaceCoin() {
        String s = "pre [icon:Coin coinAmount]\n";
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("coinAmount", 47);
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof CoinPrice));
        CoinPrice price = (CoinPrice)result.getChildren().get(1);
        TestCase.assertEquals((int)price.getAmount(), (int)47);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceCoinWithValue() {
        String s = "pre [icon:Coin 47]\n";
        HashMap parameters = new HashMap();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof CoinPrice));
        CoinPrice price = (CoinPrice)result.getChildren().get(1);
        TestCase.assertEquals((int)price.getAmount(), (int)47);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceBarrel() {
        String s = "pre [icon:Barrel amount]\n";
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", 47);
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof BarrelAmount));
        BarrelAmount amount = (BarrelAmount)result.getChildren().get(1);
        TestCase.assertEquals((int)amount.getAmount(), (int)47);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceBarrelWithAmount() {
        String s = "pre [icon:Barrel 47]\n";
        HashMap parameters = new HashMap();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof BarrelAmount));
        BarrelAmount amount = (BarrelAmount)result.getChildren().get(1);
        TestCase.assertEquals((int)amount.getAmount(), (int)47);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceBale() {
        String s = "pre [icon:Bale amount]\n";
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", 47);
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof BaleAmount));
        BaleAmount amount = (BaleAmount)result.getChildren().get(1);
        TestCase.assertEquals((int)amount.getAmount(), (int)47);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceBaleWithAmount() {
        String s = "pre [icon:Bale 47]\n";
        HashMap parameters = new HashMap();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof BaleAmount));
        BaleAmount amount = (BaleAmount)result.getChildren().get(1);
        TestCase.assertEquals((int)amount.getAmount(), (int)47);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceMappedImage() {
        String s = "pre [image:Segment images/MapSegment1 visibleSegments] post\n";
        HashMap parameters = new HashMap();
        ArrayList<Integer> visibleSegs = new ArrayList<Integer>();
        visibleSegs.add(3);
        visibleSegs.add(7);
        parameters.put("visibleSegments", visibleSegs);
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof StackPane));
        StackPane imageStack = (StackPane)result.getChildren().get(1);
        ImageView imgView = null;
        Rectangle ph = null;
        for (Node node : imageStack.getChildren()) {
            if (node instanceof ImageView) {
                imgView = (ImageView)node;
            }
            if (!(node instanceof Rectangle)) continue;
            ph = (Rectangle)node;
        }
        TestCase.assertNotNull(imgView);
        TestCase.assertNotNull(ph);
        TestCase.assertEquals((double)4711.0, (double)ph.getWidth(), (double)0.001);
        TestCase.assertEquals((Object)Color.TRANSPARENT, (Object)ph.getFill());
        Shape clip = (Shape)imgView.getClip();
        TestCase.assertNotNull((Object)clip);
        TestCase.assertFalse((boolean)clip.contains(60.0, 60.0));
        TestCase.assertFalse((boolean)clip.contains(180.0, 60.0));
        TestCase.assertTrue((boolean)clip.contains(300.0, 60.0));
        TestCase.assertFalse((boolean)clip.contains(60.0, 180.0));
        TestCase.assertFalse((boolean)clip.contains(180.0, 180.0));
        TestCase.assertFalse((boolean)clip.contains(300.0, 180.0));
        TestCase.assertTrue((boolean)clip.contains(60.0, 300.0));
        TestCase.assertFalse((boolean)clip.contains(180.0, 300.0));
        TestCase.assertFalse((boolean)clip.contains(300.0, 300.0));
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"post\n");
    }

    @Test
    public void shouldReplacedImage() {
        String s = "pre [image /images/MapSegment1.png] post\n";
        HashMap parameters = new HashMap();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof StackPane));
        StackPane imageStack = (StackPane)result.getChildren().get(1);
        ImageView imgView = null;
        Rectangle ph = null;
        for (Node node : imageStack.getChildren()) {
            if (node instanceof ImageView) {
                imgView = (ImageView)node;
            }
            if (!(node instanceof Rectangle)) continue;
            ph = (Rectangle)node;
        }
        TestCase.assertNotNull(imgView);
        TestCase.assertNotNull(ph);
        TestCase.assertEquals((double)4711.0, (double)ph.getWidth(), (double)0.001);
        TestCase.assertEquals((Object)Color.TRANSPARENT, (Object)ph.getFill());
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"post\n");
    }

    @Test
    public void shouldReplaceGenericImage() {
        String s = "pre [icon:Generic icons/64/cannonballs_icon]\n";
        HashMap parameters = new HashMap();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof Group));
        Group g = (Group)result.getChildren().get(1);
        TestCase.assertEquals((int)1, (int)g.getChildren().size());
        TestCase.assertTrue((boolean)(g.getChildren().get(0) instanceof ImageView));
        ImageView icon = (ImageView)g.getChildren().get(0);
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReplaceGenericImageRepeated() {
        String s = "pre [icon:Generic icons/64/cannonballs_icon 3]\n";
        HashMap parameters = new HashMap();
        Font fontUsed = Font.getDefault();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre ");
        TestCase.assertTrue((boolean)(result.getChildren().get(1) instanceof Group));
        Group g = (Group)result.getChildren().get(1);
        TestCase.assertEquals((int)1, (int)g.getChildren().size());
        TestCase.assertTrue((boolean)(g.getChildren().get(0) instanceof HBox));
        HBox hbox = (HBox)g.getChildren().get(0);
        TestCase.assertEquals((int)3, (int)hbox.getChildren().size());
        for (Node node : hbox.getChildren()) {
            TestCase.assertTrue((boolean)(node instanceof ImageView));
        }
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)"\n");
    }

    @Test
    public void shouldReturnTemplateStringUnchanged() {
        String s = "The fox jumps over the lazy dog\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        String result = this.factory.replaceTextParameters(s, parameters);
        TestCase.assertEquals((String)"The fox jumps over the lazy dog\n", (String)result);
    }

    @Test
    public void shouldReplaceOnePlaceholder() {
        String s = "The fox jumps over the lazy dog [dogName]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        String result = this.factory.replaceTextParameters(s, parameters);
        TestCase.assertEquals((String)"The fox jumps over the lazy dog Max\n", (String)result);
    }

    @Test
    public void shouldReplaceTwoPlaceholder() {
        String s = "The fox [foxName] jumps over the lazy dog [dogName]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        parameters.put("foxName", "Gustav");
        String result = this.factory.replaceTextParameters(s, parameters);
        TestCase.assertEquals((String)"The fox Gustav jumps over the lazy dog Max\n", (String)result);
    }

    @Test
    public void eachNewlineShouldCreateItsOwnBlock() {
        String s = "pre \ndogName\n inter dogName\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dogName", "Max");
        parameters.put("foxName", "Gustav");
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)text.getText(), (String)"pre \n");
        text = (Text)result.getChildren().get(1);
        TestCase.assertEquals((String)text.getText(), (String)"dogName\n");
        text = (Text)result.getChildren().get(2);
        TestCase.assertEquals((String)text.getText(), (String)" inter dogName\n");
    }

    @Test
    public void shouldCreateIconTextWithLeading() {
        String s = "   [icon:Generic icons/64/cannonballs_icon 1]\n";
        HashMap parameters = new HashMap();
        DecoratedText result = this.factory.createDecoratedText(s, parameters);
        Text text = (Text)result.getChildren().get(0);
        TestCase.assertEquals((String)"' '", (String)("'" + text.getText() + "'"));
        text = (Text)result.getChildren().get(1);
        TestCase.assertEquals((String)"'   '", (String)("'" + text.getText() + "'"));
    }
}

