/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.NoticeBoardScrollPaneContent;
import ch.sahits.game.javafx.model.NoticeBoardMenu;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.LinkedList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;

public abstract class NoticeBoard
extends Group {
    public static final int DEFAULT_WIDTH = 216;
    private final NoticeBoardScrollPaneContent nbScrollPane;
    protected LinkedList<NoticeBoardMenu> noticeBoardMenu = new LinkedList();

    public NoticeBoard() {
        this.setManaged(false);
        String cssFileName = NoticeBoard.class.getSimpleName() + ".css";
        URL resource = NoticeBoard.class.getResource(cssFileName);
        this.getStylesheets().add((Object)resource.toExternalForm());
        this.getStyleClass().add((Object)"noticeBoardText");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setLayoutX(20.0);
        scrollPane.setLayoutY(5.0);
        scrollPane.setMaxWidth(216.0);
        scrollPane.setMinWidth(216.0);
        scrollPane.setMaxHeight(233.0);
        scrollPane.setMinHeight(233.0);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.nbScrollPane = new NoticeBoardScrollPaneContent();
        scrollPane.setContent((Node)this.nbScrollPane);
        this.getChildren().addAll((Object[])new Node[]{scrollPane});
    }

    public void addMenu(NoticeBoardMenu menu) {
        if (this.noticeBoardMenu.contains(menu)) {
            throw new IllegalArgumentException("The menu may not be added twice.");
        }
        this.noticeBoardMenu.add(menu);
        if (Platform.isFxApplicationThread()) {
            this.nbScrollPane.setContent(Optional.of(menu));
        } else {
            Platform.runLater(() -> this.nbScrollPane.setContent(Optional.of(menu)));
        }
    }

    public void closeNoticeBoard() {
        if (!this.noticeBoardMenu.isEmpty()) {
            this.noticeBoardMenu.removeLast();
        }
        Optional<Object> optMenu = this.noticeBoardMenu.isEmpty() ? Optional.empty() : Optional.of(this.noticeBoardMenu.getLast());
        if (Platform.isFxApplicationThread()) {
            this.nbScrollPane.setContent(optMenu);
        } else {
            Platform.runLater(() -> this.nbScrollPane.setContent(optMenu));
        }
    }

    public void reset(NoticeBoardMenu menu) {
        NoticeBoardMenu last = this.noticeBoardMenu.getLast();
        Preconditions.checkArgument((menu.getType() == last.getType() ? 1 : 0) != 0, (Object)"The displayed menu has a different type than the one to replace it with.");
        this.noticeBoardMenu.removeLast();
        this.addMenu(menu);
    }
}

