/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;

@ClassCategory(value={EClassCategory.HANDLER})
public class AggregateEventHandler<T extends Event>
implements EventHandler<T> {
    @ListType(value=EventHandler.class)
    private final List<EventHandler<T>> eventHandlers = new ArrayList<EventHandler<T>>();

    public void addEventHandler(EventHandler<T> eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    public void handle(T t) {
        for (EventHandler<T> eventHandler : this.eventHandlers) {
            if (t.isConsumed()) break;
            eventHandler.handle(t);
        }
    }
}

