/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.AbstractNoticeBoardMenuProvider;
import ch.sahits.game.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardCityHallMenuProvider
extends AbstractNoticeBoardMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        switch (type) {
            case CITY_HALL_ALDERMAN_OFFICE: {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.hanseaticInfo", new Object[0], this.locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_HANSEATIC_INFO);
                entries.add(entry);
                if (proxy.getPlayer().getRank() != ESocialRank.ALDERMAN || !proxy.getPlayer().getHometown().equals(proxy.getCity())) break;
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.aldermanOffice", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_ALDERMAN_OFFICE);
                entries.add(entry);
                break;
            }
            case CITY_HALL_MEETINGROOM: {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.meetings", new Object[0], this.locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_MEETING_ROOM);
                entry.setSelected(true);
                entries.add(entry);
                break;
            }
            case CITY_HALL_MAYORS_OFFICE: {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.townInfo", new Object[0], this.locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_TOWN_INFO);
                entries.add(entry);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.treasury", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_TREASURY);
                entries.add(entry);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityWall", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_CITY_WALL);
                entries.add(entry);
                break;
            }
            case CITY_HALL_NOTICE_BOARD: {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallPublicNotice", new Object[0], this.locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_NOTICE);
                entries.add(entry);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallOutriggerNotice", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.CITY_HALL_OUTRIGGER);
                entries.add(entry);
            }
        }
        return entries;
    }
}

