/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TextEllipsisCalculator {
    private static final String ELLIPSIS = "...";
    @Autowired
    private TextSizingUtility sizing;

    public String calculateEllipsis(Font font, String text, double maxWidth) {
        double ellipsisWidth = this.sizing.calculate(ELLIPSIS, font).getWidth();
        int guessNbChars = Math.min(this.sizing.guessNumberOfCharacters(maxWidth - ellipsisWidth, font), text.length() - 1);
        String substr = text.substring(0, guessNbChars) + ELLIPSIS;
        boolean reducedNbCharacters = false;
        while (this.sizing.calculate(substr, font).getWidth() > maxWidth) {
            reducedNbCharacters = true;
            substr = text.substring(0, --guessNbChars) + ELLIPSIS;
        }
        if (!reducedNbCharacters) {
            while (this.sizing.calculate(substr, font).getWidth() < maxWidth && guessNbChars < text.length() - 1) {
                substr = text.substring(0, ++guessNbChars) + ELLIPSIS;
            }
        }
        if (this.sizing.calculate(substr, font).getWidth() > maxWidth) {
            substr = text.substring(0, guessNbChars - 1) + ELLIPSIS;
        }
        return substr;
    }
}

