/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.util;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IModelTranslationService;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ModelTranslations
implements IModelTranslationService {
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;

    public String getLocalDisplayName(EWeapon weapon) {
        return this.messages.getMessage(weapon.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(EWare ware) {
        return this.messages.getMessage(ware.getWareID(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(ICareer career) {
        if (career instanceof EEconomicCareer) {
            return this.messages.getMessage(((EEconomicCareer)career).name(), new Object[0], this.locale.getCurrentLocal());
        }
        if (career instanceof EMilitantCareer) {
            return this.messages.getMessage(((EMilitantCareer)career).name(), new Object[0], this.locale.getCurrentLocal());
        }
        throw new IllegalArgumentException("Unknown career implementation: " + career.getClass().getName());
    }

    public String getLocalDisplayName(ESocialRank rank) {
        return this.messages.getMessage(rank.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(EShipType type) {
        return this.messages.getMessage(type.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayNameWithArticle(EShipType type, boolean upperCaseArticle) {
        String typeName = this.getLocalDisplayName(type);
        String key = "ch.sahits.game.javafx.util.ModelTranslations." + type.name().toLowerCase() + "Article";
        String article = EShipType.HOLK == type || EShipType.CRAYER == type ? this.getLocalDisplayDistinctArticle(true, upperCaseArticle) : this.getLocalDisplayDistinctArticle(false, upperCaseArticle);
        return article + " " + typeName;
    }

    public String getLocalDisplayDistinctArticle(boolean male, boolean uppercase) {
        String key = "articleMale";
        if (!male) {
            key = "articleFemale";
        }
        String article = this.messages.getMessage(key, new Object[0], this.locale.getCurrentLocal());
        if (uppercase) {
            article = article.substring(0, 1).toUpperCase() + article.substring(1);
        }
        return article;
    }

    public String toShortDate(DateTime c) {
        int day = c.getDayOfMonth();
        int month = c.getMonthOfYear();
        StringBuilder sb = new StringBuilder();
        sb.append(day).append(". ");
        sb.append(this.messages.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal()));
        return sb.toString();
    }

    private DateTime getEndOfWeekInternal(DateTime date) {
        int cdow = date.getDayOfWeek();
        DateTime lastDayOfWeek = date.plusDays(7 - cdow);
        return lastDayOfWeek;
    }

    public String getEndOfWeek(DateTime date) {
        DateTime lastSun = this.getEndOfWeekInternal(date);
        return this.toShortDate(lastSun);
    }

    public String toDisplayString(int day, int month, int year) {
        StringBuilder sb = new StringBuilder();
        sb.append(day).append(". ");
        sb.append(this.messages.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal())).append(" ");
        sb.append(year);
        return sb.toString();
    }

    public String toDisplayString(DateTime date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthOfYear();
        int year = date.getYear();
        return this.toDisplayString(day, month, year);
    }

    public String getStartOfWeek(DateTime date) {
        DateTime lastMon = this.getStartOfWeekInternal(date);
        return this.toShortDate(lastMon);
    }

    private DateTime getStartOfWeekInternal(DateTime date) {
        DateTime lastMonday = date.minusDays(date.getDayOfWeek() - 1);
        return lastMonday;
    }
}

