package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.scene.control.Label;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

/**
 * Factory class providing the titles for the notice board menus.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class NoticeBoardMenuTitleProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public Label createTitle(ENoticeBoardType type) {
        Label title = new Label();
        String s = "";
         switch (type) {
             case MESSAGE:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.messages", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CHURCH:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.church", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_NOTICE_BOARD:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallNoticeBoard", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_MAYORS_OFFICE:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.mayorsOffice", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_ALDERMAN_OFFICE:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.alderman", new Object[]{}, locale.getCurrentLocal());
                 break;
             case CITY_HALL_MEETINGROOM:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case LOANER:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case MARKET_PLACE:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.marketplace.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case SHIP_SELECTION:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.shipSelection.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case SHIPYARD:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.shipyard.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case TAVERN:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.tavern.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case TRADING:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.trading.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case TRADING_OFFICE:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.tradingOffice.title", new Object[]{}, locale.getCurrentLocal());
                 break;
             case GUILD:
                 s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.guild.title", new Object[]{}, locale.getCurrentLocal());
                 break;
         }
        title.setText(s);
        title.getStyleClass().add("noticeBoardTitle");
        return title;
    }
}
